/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.addon;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import de.erdbeerbaerlp.dcintegration.common.Discord;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordAddonMeta;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordIntegrationAddon;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AddonLoader {
    private static final File addonDir = new File(Variables.discordDataDir, "addons");
    private static final FilenameFilter jarFilter = (dir, name) -> !new File(dir, name).isDirectory() && name.toLowerCase().endsWith(".jar");
    private static final HashMap<DiscordAddonMeta, DiscordIntegrationAddon> addons = new HashMap();

    public static void loadAddon(Discord dc, File jar) {
        block8: {
            try {
                JarFile jf = new JarFile(jar);
                JarEntry entry = jf.getJarEntry("DiscordIntegrationAddon.toml");
                if (entry != null) {
                    InputStream is = jf.getInputStream(entry);
                    DiscordAddonMeta addonMeta = new Toml().read(is).to(DiscordAddonMeta.class);
                    is.close();
                    if (addonMeta.getClassPath() == null || addonMeta.getName() == null || addonMeta.getVersion() == null) {
                        System.err.println("Failed to load Addon '" + jar.getName() + "'! Toml is missing parameters! (Required are name, version, classPath)");
                    }
                    try {
                        URLClassLoader child = new URLClassLoader(new URL[]{jar.toURI().toURL()}, AddonLoader.class.getClassLoader());
                        Class<DiscordIntegrationAddon> addonClass = Class.forName(addonMeta.getClassPath(), true, child).asSubclass(DiscordIntegrationAddon.class);
                        DiscordIntegrationAddon addon = addonClass.newInstance();
                        addons.put(addonMeta, addon);
                        try {
                            addon.load(dc);
                            break block8;
                        }
                        catch (Exception e) {
                            System.err.println("An exception occurred while loading addon " + addonMeta.getName());
                            e.printStackTrace();
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        System.err.println("Failed to load Addon '" + addonMeta.getName() + "' version '" + addonMeta.getVersion() + "'!");
                        e.printStackTrace();
                    }
                    break block8;
                }
                System.err.println("Found non-addon jar file " + jar.getName());
            }
            catch (IOException e) {
                System.err.println("Failed to load addon " + jar.getName());
                e.printStackTrace();
            }
        }
    }

    public static void loadAddons(Discord dc) {
        File[] jars;
        if (!addonDir.exists()) {
            addonDir.mkdirs();
        }
        for (File jar : jars = addonDir.listFiles(jarFilter)) {
            AddonLoader.loadAddon(dc, jar);
        }
    }

    public static void unloadAddons(Discord discord) {
        for (DiscordIntegrationAddon addon : addons.values()) {
            try {
                addon.unload(discord);
            }
            catch (Exception e) {
                System.err.println("An exception occurred while unloading addon class " + addon.getClass().getName());
                e.printStackTrace();
            }
        }
        addons.clear();
    }

    @Nullable
    public static DiscordAddonMeta getAddonMeta(@Nonnull DiscordIntegrationAddon inst) {
        AtomicReference meta = new AtomicReference();
        addons.forEach((a, b) -> {
            if (b.equals(inst)) {
                meta.set(a);
            }
        });
        return (DiscordAddonMeta)meta.get();
    }

    @Nonnull
    public static Set<DiscordAddonMeta> getAddonMetas() {
        return addons.keySet();
    }

    @Nonnull
    public static Collection<DiscordIntegrationAddon> getAddons() {
        return addons.values();
    }

    public static void reloadAll() {
        AddonLoader.getAddons().forEach(DiscordIntegrationAddon::reload);
    }

    @Nonnull
    public static File getAddonDir() {
        return addonDir;
    }
}

