/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands;

import dcshadow.com.google.gson.JsonArray;
import dcshadow.com.google.gson.JsonElement;
import dcshadow.com.google.gson.JsonObject;
import dcshadow.com.google.gson.JsonParser;
import dcshadow.javax.annotation.Nonnull;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.CommandFromCFG;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.CommandHelp;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.CommandList;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.CommandUptime;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.DMCommand;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.DMHelpCommand;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.LinkCommand;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.SettingsCommand;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.WhitelistCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandRegistry {
    private static final List<DMCommand> dmCommands = new ArrayList<DMCommand>();
    private static List<DiscordCommand> commands = new ArrayList<DiscordCommand>();

    public static void registerDefaultCommandsFromConfig() {
        if (Configuration.instance().commands.helpCmdEnabled) {
            CommandRegistry.registerCommand(new CommandHelp());
        }
        if (Configuration.instance().commands.listCmdEnabled) {
            CommandRegistry.registerCommand(new CommandList());
        }
        if (Configuration.instance().commands.uptimeCmdEnabled) {
            CommandRegistry.registerCommand(new CommandUptime());
        }
        if (Configuration.instance().linking.enableLinking) {
            CommandRegistry.registerCommand(new DMHelpCommand());
            CommandRegistry.registerCommand(new SettingsCommand());
            if (Configuration.instance().linking.whitelistMode) {
                CommandRegistry.registerCommand(new WhitelistCommand());
            } else {
                CommandRegistry.registerCommand(new LinkCommand());
            }
        }
        CommandRegistry.registerConfigCommands();
    }

    public static void registerConfigCommands() {
        JsonObject commandJson = new JsonParser().parse(Configuration.instance().commands.customCommandJSON).getAsJsonObject();
        System.out.println("Detected to load " + commandJson.size() + " commands to load from config");
        for (Map.Entry<String, JsonElement> cmd : commandJson.entrySet()) {
            String[] stringArray;
            JsonObject cmdVal = cmd.getValue().getAsJsonObject();
            if (!cmdVal.has("mcCommand")) {
                System.err.println("Skipping command " + cmd.getKey() + " because it is invalid! Check your config!");
                continue;
            }
            String mcCommand = cmdVal.get("mcCommand").getAsString();
            String desc = cmdVal.has("description") ? cmdVal.get("description").getAsString() : "No Description";
            boolean admin = !cmdVal.has("adminOnly") || cmdVal.get("adminOnly").getAsBoolean();
            boolean useArgs = !cmdVal.has("useArgs") || cmdVal.get("useArgs").getAsBoolean();
            String argText = "<args>";
            if (cmdVal.has("argText")) {
                argText = cmdVal.get("argText").getAsString();
            }
            String[] aliases = new String[]{};
            if (cmdVal.has("aliases") && cmdVal.get("aliases").isJsonArray()) {
                aliases = new String[cmdVal.getAsJsonArray("aliases").size()];
                for (int i = 0; i < aliases.length; ++i) {
                    aliases[i] = cmdVal.getAsJsonArray("aliases").get(i).getAsString();
                }
            }
            if (cmdVal.has("channelID") && cmdVal.get("channelID") instanceof JsonArray) {
                stringArray = MessageUtils.makeStringArray(cmdVal.get("channelID").getAsJsonArray());
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "0";
            }
            String[] channelID = stringArray;
            CommandFromCFG regCmd = new CommandFromCFG(cmd.getKey(), desc, mcCommand, admin, aliases, useArgs, argText, channelID);
            if (CommandRegistry.registerCommand(regCmd)) continue;
            System.err.println("Failed Registering command \"" + cmd.getKey() + "\" because it would override an existing command!");
        }
        System.out.println("Finished registering! Registered " + commands.size() + " commands");
    }

    public static boolean registerCommand(@Nonnull DiscordCommand cmd) {
        if (cmd instanceof DMCommand) {
            ArrayList<DMCommand> toRemove = new ArrayList<DMCommand>();
            for (DMCommand c : dmCommands) {
                if (!cmd.isConfigCommand() && cmd.equals(c)) {
                    return false;
                }
                if (!cmd.isConfigCommand() || !cmd.equals(c)) continue;
                toRemove.add(c);
            }
            for (DMCommand cm : toRemove) {
                dmCommands.remove(cm);
            }
            return dmCommands.add((DMCommand)cmd);
        }
        ArrayList<DiscordCommand> toRemove = new ArrayList<DiscordCommand>();
        for (DiscordCommand c : commands) {
            if (!cmd.isConfigCommand() && cmd.equals(c)) {
                return false;
            }
            if (!cmd.isConfigCommand() || !cmd.equals(c)) continue;
            toRemove.add(c);
        }
        for (DiscordCommand cm : toRemove) {
            commands.remove(cm);
        }
        return commands.add(cmd);
    }

    public static void reRegisterAllCommands() {
        List<DiscordCommand> cmds = commands;
        System.out.println("Reloading " + cmds.size() + " commands");
        commands = new ArrayList<DiscordCommand>();
        for (DiscordCommand cmd : cmds) {
            if (cmd.isConfigCommand()) continue;
            commands.add(cmd);
        }
        System.out.println("Registered " + commands.size() + " commands");
        List<DMCommand> dmcmds = dmCommands;
        System.out.println("Reloading " + dmcmds.size() + " DM commands");
        commands = new ArrayList<DiscordCommand>();
        for (DMCommand cmd : dmcmds) {
            if (cmd.isConfigCommand()) continue;
            commands.add(cmd);
        }
        System.out.println("Registered " + dmCommands.size() + " commands");
    }

    @Nonnull
    public static List<DiscordCommand> getCommandList() {
        return commands;
    }

    @Nonnull
    public static List<DMCommand> getDMCommandList() {
        return dmCommands;
    }
}

