/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat;

import dcshadow.javax.annotation.Nonnull;
import dcshadow.org.apache.commons.lang3.ArrayUtils;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.util.Arrays;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

public class CommandFromCFG
extends DiscordCommand {
    private final String cmd;
    private final String desc;
    private final String mcCmd;
    private final String argText;
    private final boolean admin;
    private final String[] aliases;
    private final boolean useArgs;
    private final String[] channelIDs;

    public CommandFromCFG(@Nonnull String cmd, @Nonnull String description, @Nonnull String mcCommand, boolean adminOnly, @Nonnull String[] aliases, boolean useArgs, @Nonnull String argText, @Nonnull String[] channelIDs) {
        super("");
        this.channelIDs = channelIDs;
        this.isConfigCmd = true;
        this.desc = description;
        this.cmd = cmd;
        this.admin = adminOnly;
        this.mcCmd = mcCommand;
        this.aliases = aliases;
        this.useArgs = useArgs;
        this.argText = argText;
    }

    @Override
    public boolean worksInChannel(String channelID) {
        return Arrays.equals(this.channelIDs, new String[]{"00"}) || Arrays.equals(this.channelIDs, new String[]{"0"}) && channelID.equals(Configuration.instance().general.botChannel) || ArrayUtils.contains(this.channelIDs, channelID);
    }

    @Override
    public String getName() {
        return this.cmd;
    }

    @Override
    public boolean adminOnly() {
        return this.admin;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getCommandUsage() {
        if (this.useArgs) {
            return super.getCommandUsage() + " " + this.argText;
        }
        return super.getCommandUsage();
    }

    @Override
    public void execute(String[] args2, MessageReceivedEvent cmdMsg) {
        int argsCount;
        String cmd = this.mcCmd;
        String argString = "";
        int n = argsCount = this.useArgs ? args2.length : 0;
        if (argsCount > 0) {
            for (int i = 0; i < argsCount; ++i) {
                argString = argString + " " + args2[i];
            }
        }
        cmd = !cmd.contains("%args%") ? cmd + argString : cmd.replace("%args%", argString.trim());
        Variables.discord_instance.srv.runMcCommand(cmd, cmdMsg);
    }
}

