/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands.inChat;

import dcshadow.javax.annotation.Nonnull;
import dcshadow.org.apache.commons.lang3.ArrayUtils;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.util.Arrays;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

public abstract class DiscordCommand {
    private final String[] EVERYWHERE = new String[]{"00"};
    private final String[] ONLY_IN_BOT_CHANNEL = new String[]{"0"};
    private final String[] channelIDs;
    boolean isConfigCmd = false;

    protected DiscordCommand(@Nonnull String[] channelIDs) {
        this.channelIDs = channelIDs;
    }

    protected DiscordCommand(@Nonnull String channelID) {
        this.channelIDs = new String[]{channelID};
    }

    public final boolean worksInChannel(TextChannel channel) {
        if (channel == null) {
            return false;
        }
        return this.worksInChannel(channel.getId());
    }

    public boolean worksInChannel(@Nonnull String channelID) {
        if (Arrays.equals(this.channelIDs, this.EVERYWHERE)) {
            return true;
        }
        if (Arrays.equals(this.channelIDs, this.ONLY_IN_BOT_CHANNEL)) {
            return channelID.equals(Configuration.instance().general.botChannel);
        }
        return ArrayUtils.contains(this.channelIDs, channelID);
    }

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract String[] getAliases();

    @Nonnull
    public abstract String getDescription();

    public boolean adminOnly() {
        return false;
    }

    public abstract void execute(@Nonnull String[] var1, @Nonnull MessageReceivedEvent var2);

    public boolean includeInHelp() {
        return true;
    }

    public boolean canUserExecuteCommand(@Nonnull User user) {
        Member m = null;
        for (Member me : Variables.discord_instance.getChannel().getMembers()) {
            if (!me.getUser().equals(user)) continue;
            m = me;
            break;
        }
        if (m == null) {
            return false;
        }
        return !this.adminOnly() || Variables.discord_instance.hasAdminRole(m.getRoles());
    }

    public String getCommandUsage() {
        return Configuration.instance().commands.prefix + this.getName();
    }

    public final boolean equals(DiscordCommand cmd) {
        return cmd.getName().equals(this.getName());
    }

    public final String getPlayerNotFoundMsg(String playerName) {
        return Configuration.instance().localization.commands.playerNotFound.replace("%player%", playerName);
    }

    public final boolean isConfigCommand() {
        return this.isConfigCmd;
    }
}

