/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs;

import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.DMCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerSettings;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

public class SettingsCommand
extends DMCommand {
    @Override
    public String getName() {
        return "settings";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"set"};
    }

    @Override
    public String getDescription() {
        return Configuration.instance().localization.commands.descriptions.settings;
    }

    @Override
    public void execute(String[] args2, MessageReceivedEvent ev) {
        if (!PlayerLinkController.isDiscordLinked(ev.getAuthor().getId())) {
            ev.getChannel().sendMessage(Configuration.instance().localization.linking.notLinked.replace("%method%", Configuration.instance().linking.whitelistMode ? Configuration.instance().localization.linking.linkMethodWhitelist.replace("%prefix%", Configuration.instance().commands.prefix) : Configuration.instance().localization.linking.linkMethodIngame)).queue();
            return;
        }
        if (args2.length == 2 && args2[0].equals("get")) {
            if (Variables.discord_instance.getSettings().containsKey(args2[1])) {
                PlayerSettings settings = PlayerLinkController.getSettings(ev.getAuthor().getId(), null);
                try {
                    ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.personalSettingGet.replace("%bool%", settings.getClass().getField(args2[1]).getBoolean(settings) ? "true" : "false")).queue();
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            } else {
                ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.invalidPersonalSettingKey.replace("%key%", args2[1])).queue();
            }
        } else if (args2.length == 3 && args2[0].equals("set")) {
            if (Variables.discord_instance.getSettings().containsKey(args2[1])) {
                boolean newval;
                PlayerSettings settings = PlayerLinkController.getSettings(ev.getAuthor().getId(), null);
                try {
                    newval = Boolean.parseBoolean(args2[2]);
                }
                catch (NumberFormatException e) {
                    newval = false;
                }
                boolean newValue = newval;
                try {
                    settings.getClass().getDeclaredField(args2[1]).set(settings, newValue);
                    PlayerLinkController.updatePlayerSettings(ev.getAuthor().getId(), null, settings);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.settingUpdateFailed).queue();
                }
                ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.settingUpdateSuccessful).queue();
            } else {
                ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.invalidPersonalSettingKey.replace("%key%", args2[1])).queue();
            }
        } else if (args2.length == 1) {
            MessageBuilder msg = new MessageBuilder(Configuration.instance().localization.personalSettings.settingsCommandUsage.replace("%prefix%", Configuration.instance().commands.prefix));
            EmbedBuilder b = new EmbedBuilder();
            PlayerSettings settings = PlayerLinkController.getSettings(ev.getAuthor().getId(), null);
            Variables.discord_instance.getSettings().forEach((name, desc) -> {
                if (Configuration.instance().webhook.enable || !name.equals("useDiscordNameInChannel")) {
                    try {
                        b.addField(name + " == " + ((Boolean)settings.getClass().getDeclaredField((String)name).get(settings) != false ? "true" : "false"), (String)desc, false);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        b.addField(name + " == Unknown", (String)desc, false);
                    }
                }
            });
            b.setAuthor(Configuration.instance().localization.personalSettings.personalSettingsHeader);
            msg.setEmbed(b.build());
            ev.getChannel().sendMessage(msg.build()).queue();
        } else {
            ev.getChannel().sendMessage(Configuration.instance().localization.personalSettings.settingsCommandUsage.replace("%prefix%", Configuration.instance().commands.prefix)).queue();
        }
    }
}

