/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs;

import dcshadow.com.google.gson.JsonElement;
import dcshadow.com.google.gson.JsonParser;
import dcshadow.com.google.gson.stream.JsonReader;
import de.erdbeerbaerlp.dcintegration.common.Discord;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.inDMs.DMCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

public class WhitelistCommand
extends DMCommand {
    private final String uuidRegex = "(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)";

    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public String getDescription() {
        return Configuration.instance().localization.commands.descriptions.whitelist;
    }

    @Override
    public void execute(String[] args2, MessageReceivedEvent ev) {
        if (Variables.discord_instance.getChannel().getGuild().isMember(ev.getAuthor())) {
            Member m = Variables.discord_instance.getChannel().getGuild().getMember(ev.getAuthor());
            if (Configuration.instance().linking.requiredRoles.length != 0) {
                AtomicBoolean ok = new AtomicBoolean(false);
                m.getRoles().forEach(role -> {
                    for (String s : Configuration.instance().linking.requiredRoles) {
                        if (!s.equals(role.getId())) continue;
                        ok.set(true);
                    }
                });
                if (!ok.get()) {
                    ev.getChannel().sendMessage(Configuration.instance().localization.linking.link_requiredRole).queue();
                    return;
                }
            }
        } else {
            ev.getChannel().sendMessage(Configuration.instance().localization.linking.link_notMember).queue();
            return;
        }
        if (PlayerLinkController.isDiscordLinkedJava(ev.getAuthor().getId())) {
            ev.getChannel().sendMessage(Configuration.instance().localization.linking.alreadyLinked.replace("%player%", MessageUtils.getNameFromUUID(PlayerLinkController.getPlayerFromDiscord(ev.getAuthor().getId())))).queue();
            return;
        }
        if (args2.length > 1) {
            ev.getChannel().sendMessage(Configuration.instance().localization.commands.tooManyArguments).queue();
            return;
        }
        if (args2.length < 1) {
            ev.getChannel().sendMessage(Configuration.instance().localization.commands.notEnoughArguments).queue();
            return;
        }
        String s = args2[0];
        try {
            UUID u;
            String oldS = s;
            try {
                if (!s.contains("-")) {
                    s = s.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                }
                u = UUID.fromString(s);
            }
            catch (Exception e) {
                try {
                    URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + oldS);
                    HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                    if (con.getResponseCode() == 204) {
                        throw new IOException();
                    }
                    JsonReader r = new JsonReader(new InputStreamReader(con.getInputStream()));
                    JsonParser p = new JsonParser();
                    JsonElement json = p.parse(r);
                    u = UUID.fromString(json.getAsJsonObject().get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                }
                catch (IOException ex) {
                    u = Discord.dummyUUID;
                    ex.printStackTrace();
                }
            }
            boolean linked = PlayerLinkController.linkPlayer(ev.getAuthor().getId(), u);
            if (linked) {
                ev.getChannel().sendMessage(Configuration.instance().localization.linking.linkSuccessful.replace("%prefix%", Configuration.instance().commands.prefix).replace("%player%", MessageUtils.getNameFromUUID(u))).queue();
            } else {
                ev.getChannel().sendMessage(Configuration.instance().localization.linking.linkFailed).queue();
            }
        }
        catch (IllegalArgumentException e) {
            ev.getChannel().sendMessage(Configuration.instance().localization.linking.link_argumentNotUUID.replace("%prefix%", Configuration.instance().commands.prefix).replace("%arg%", s)).queue();
        }
    }

    @Override
    public boolean canUserExecuteCommand(User user) {
        if (user == null) {
            return false;
        }
        return !PlayerLinkController.isDiscordLinkedJava(user.getId());
    }
}

