/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage;

import dcshadow.com.google.gson.Gson;
import dcshadow.com.google.gson.GsonBuilder;
import dcshadow.com.google.gson.JsonArray;
import dcshadow.com.google.gson.JsonElement;
import dcshadow.com.google.gson.JsonParser;
import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import de.erdbeerbaerlp.dcintegration.common.Discord;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerSettings;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;

public class PlayerLinkController {
    private static final File playerLinkedFile = new File(Variables.discordDataDir, "LinkedPlayers.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser parser = new JsonParser();

    public static boolean isPlayerLinked(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        if (PlayerLinkController.isJavaPlayerLinked(player)) {
            return true;
        }
        return PlayerLinkController.isBedrockPlayerLinked(player);
    }

    public static boolean isBedrockPlayerLinked(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.floodgateUUID.isEmpty() || !o.floodgateUUID.equals(player.toString())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isJavaPlayerLinked(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.mcPlayerUUID.isEmpty() || !o.mcPlayerUUID.equals(player.toString())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isDiscordLinked(@Nonnull String discordID) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        if (PlayerLinkController.isDiscordLinkedJava(discordID)) {
            return true;
        }
        return PlayerLinkController.isDiscordLinkedBedrock(discordID);
    }

    public static boolean isDiscordLinkedBedrock(@Nonnull String discordID) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || !o.discordID.equals(discordID)) continue;
                return !o.floodgateUUID.isEmpty();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isDiscordLinkedJava(@Nonnull String discordID) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || !o.discordID.equals(discordID)) continue;
                return !o.mcPlayerUUID.isEmpty();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Nullable
    public static UUID getPlayerFromDiscord(@Nonnull String discordID) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || o.mcPlayerUUID.isEmpty() || !o.discordID.equals(discordID)) continue;
                return UUID.fromString(o.mcPlayerUUID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static UUID getBedrockPlayerFromDiscord(@Nonnull String discordID) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || o.floodgateUUID.isEmpty() || !o.discordID.equals(discordID)) continue;
                return UUID.fromString(o.floodgateUUID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static String getDiscordFromPlayer(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        if (PlayerLinkController.isJavaPlayerLinked(player)) {
            return PlayerLinkController.getDiscordFromJavaPlayer(player);
        }
        if (PlayerLinkController.isBedrockPlayerLinked(player)) {
            return PlayerLinkController.getDiscordFromBedrockPlayer(player);
        }
        return null;
    }

    @Nullable
    public static String getDiscordFromJavaPlayer(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || o.mcPlayerUUID.isEmpty() || !o.mcPlayerUUID.equals(player.toString())) continue;
                return o.discordID;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static String getDiscordFromBedrockPlayer(@Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || o.floodgateUUID.isEmpty() || !o.floodgateUUID.equals(player.toString())) continue;
                return o.discordID;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nonnull
    public static PlayerSettings getSettings(@Nullable String discordID, @Nullable UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return new PlayerSettings();
        }
        if (player == null && discordID == null) {
            throw new IllegalArgumentException();
        }
        if (discordID == null) {
            discordID = PlayerLinkController.getDiscordFromPlayer(player);
        } else if (player == null) {
            UUID uUID = PlayerLinkController.isDiscordLinkedJava(discordID) ? PlayerLinkController.getPlayerFromDiscord(discordID) : (player = PlayerLinkController.isDiscordLinkedBedrock(discordID) ? PlayerLinkController.getBedrockPlayerFromDiscord(discordID) : null);
        }
        if (player == null || discordID == null) {
            return new PlayerSettings();
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID.isEmpty() || o.mcPlayerUUID.isEmpty() && o.floodgateUUID.isEmpty() || !o.discordID.equals(discordID) || !o.mcPlayerUUID.equals(player.toString()) && !o.floodgateUUID.equals(player.toString())) continue;
                return o.settings;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new PlayerSettings();
    }

    public static void migrateLinkPlayer(@Nonnull String discordID, @Nonnull UUID player) {
        try {
            JsonArray a = PlayerLinkController.getJson();
            PlayerLink link = new PlayerLink();
            link.discordID = discordID;
            link.mcPlayerUUID = player.toString();
            a.add(gson.toJsonTree(link));
            PlayerLinkController.saveJSON(a);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean linkPlayer(@Nonnull String discordID, @Nonnull UUID player) throws IllegalArgumentException {
        if (!Variables.discord_instance.srv.isOnlineMode() || player.equals(Discord.dummyUUID)) {
            return false;
        }
        if (PlayerLinkController.isDiscordLinkedJava(discordID) || PlayerLinkController.isPlayerLinked(player)) {
            throw new IllegalArgumentException("One link side already exists");
        }
        try {
            JsonElement el;
            boolean ignoringMessages;
            if (MessageUtils.getNameFromUUID(player) == null) {
                return false;
            }
            JsonArray a = PlayerLinkController.getJson();
            PlayerLink link = PlayerLinkController.isDiscordLinkedBedrock(discordID) ? PlayerLinkController.getUser(discordID, PlayerLinkController.getPlayerFromDiscord(discordID)) : new PlayerLink();
            link.discordID = discordID;
            link.mcPlayerUUID = player.toString();
            link.settings.ignoreDiscordChatIngame = ignoringMessages = Variables.discord_instance.ignoringPlayers.contains(player);
            if (ignoringMessages) {
                Variables.discord_instance.ignoringPlayers.remove(player);
            }
            if (PlayerLinkController.isDiscordLinkedBedrock(discordID) && a.contains(el = PlayerLinkController.getBedrockUserRaw(discordID, PlayerLinkController.getBedrockPlayerFromDiscord(discordID)))) {
                a.remove(el);
            }
            a.add(gson.toJsonTree(link));
            PlayerLinkController.saveJSON(a);
            Variables.discord_instance.callEventC(e -> e.onPlayerLink(player, discordID));
            Guild guild = Variables.discord_instance.getChannel().getGuild();
            Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
            Member member = guild.getMemberById(PlayerLinkController.getDiscordFromPlayer(UUID.fromString(link.mcPlayerUUID)));
            if (linkedRole != null && !member.getRoles().contains(linkedRole)) {
                guild.addRoleToMember(member, linkedRole).queue();
            }
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static boolean linkBedrockPlayer(@Nonnull String discordID, @Nonnull UUID bedrockPlayer) throws IllegalArgumentException {
        if (!Variables.discord_instance.srv.isOnlineMode() || bedrockPlayer.equals(Discord.dummyUUID)) {
            return false;
        }
        if (PlayerLinkController.isDiscordLinkedBedrock(discordID) || PlayerLinkController.isPlayerLinked(bedrockPlayer)) {
            throw new IllegalArgumentException("One link side already exists");
        }
        try {
            JsonElement el;
            boolean ignoringMessages;
            JsonArray a = PlayerLinkController.getJson();
            PlayerLink link = PlayerLinkController.isDiscordLinkedJava(discordID) ? PlayerLinkController.getUser(discordID, PlayerLinkController.getPlayerFromDiscord(discordID)) : new PlayerLink();
            link.discordID = discordID;
            link.floodgateUUID = bedrockPlayer.toString();
            link.settings.ignoreDiscordChatIngame = ignoringMessages = Variables.discord_instance.ignoringPlayers.contains(bedrockPlayer);
            if (ignoringMessages) {
                Variables.discord_instance.ignoringPlayers.remove(bedrockPlayer);
            }
            if (PlayerLinkController.isDiscordLinkedJava(discordID) && a.contains(el = PlayerLinkController.getUserRaw(discordID, PlayerLinkController.getPlayerFromDiscord(discordID)))) {
                a.remove(el);
            }
            a.add(gson.toJsonTree(link));
            PlayerLinkController.saveJSON(a);
            Variables.discord_instance.callEventC(e -> e.onBedrockPlayerLink(bedrockPlayer, discordID));
            Guild guild = Variables.discord_instance.getChannel().getGuild();
            Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
            Member member = guild.getMemberById(PlayerLinkController.getDiscordFromPlayer(UUID.fromString(link.mcPlayerUUID)));
            if (linkedRole != null && !member.getRoles().contains(linkedRole)) {
                guild.addRoleToMember(member, linkedRole).queue();
            }
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static boolean updatePlayerSettings(@Nullable String discordID, @Nullable UUID player, @Nonnull PlayerSettings settings) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        if (player == null && discordID == null) {
            throw new NullPointerException();
        }
        if (discordID == null) {
            discordID = PlayerLinkController.getDiscordFromPlayer(player);
        } else if (player == null) {
            UUID uUID = PlayerLinkController.isDiscordLinkedJava(discordID) ? PlayerLinkController.getPlayerFromDiscord(discordID) : (player = PlayerLinkController.isDiscordLinkedBedrock(discordID) ? PlayerLinkController.getBedrockPlayerFromDiscord(discordID) : null);
        }
        if (player == null || discordID == null) {
            throw new NullPointerException();
        }
        if (PlayerLinkController.isDiscordLinked(discordID) && PlayerLinkController.isPlayerLinked(player)) {
            try {
                JsonArray a = PlayerLinkController.getJson();
                PlayerLink link = PlayerLinkController.isDiscordLinkedBedrock(discordID) ? PlayerLinkController.getBedrockUser(discordID, player) : PlayerLinkController.getUser(discordID, player);
                for (JsonElement e : a) {
                    PlayerLink l = gson.fromJson(e, PlayerLink.class);
                    if (!l.equals(link)) continue;
                    a.remove(e);
                    break;
                }
                if (link == null) {
                    return false;
                }
                link.settings = settings;
                a.add(gson.toJsonTree(link));
                PlayerLinkController.saveJSON(a);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void saveJSON(@Nonnull JsonArray a) throws IOException {
        try (FileWriter writer = new FileWriter(playerLinkedFile);){
            gson.toJson((JsonElement)a, (Appendable)writer);
        }
    }

    public static boolean unlinkPlayer(@Nonnull String discordID, @Nonnull UUID player) {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return false;
        }
        if (!PlayerLinkController.isDiscordLinked(discordID) && !PlayerLinkController.isPlayerLinked(player)) {
            return false;
        }
        try {
            for (JsonElement e : PlayerLinkController.getJson()) {
                PlayerLink o = gson.fromJson(e, PlayerLink.class);
                if (o.discordID == null || !o.discordID.equals(discordID)) continue;
                JsonArray json = PlayerLinkController.getJson();
                json.remove(e);
                try (FileWriter writer = new FileWriter(playerLinkedFile);){
                    gson.toJson((JsonElement)json, (Appendable)writer);
                }
                Guild guild = Variables.discord_instance.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                Member member = guild.getMemberById(PlayerLinkController.getDiscordFromPlayer(UUID.fromString(o.mcPlayerUUID)));
                if (member.getRoles().contains(linkedRole)) {
                    guild.removeRoleFromMember(member, linkedRole).queue();
                }
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static PlayerLink getUser(@Nonnull String discordID, @Nonnull UUID player) throws IOException {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        JsonArray a = PlayerLinkController.getJson();
        for (JsonElement e : a) {
            PlayerLink l = gson.fromJson(e, PlayerLink.class);
            if (!l.discordID.equals(discordID) || !l.mcPlayerUUID.equals(player.toString())) continue;
            return l;
        }
        return null;
    }

    @Nullable
    private static JsonElement getUserRaw(@Nonnull String discordID, @Nonnull UUID player) throws IOException {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        JsonArray a = PlayerLinkController.getJson();
        for (JsonElement e : a) {
            PlayerLink l = gson.fromJson(e, PlayerLink.class);
            if (!l.discordID.equals(discordID) || !l.mcPlayerUUID.equals(player.toString())) continue;
            return e;
        }
        return null;
    }

    @Nullable
    private static PlayerLink getBedrockUser(@Nonnull String discordID, @Nonnull UUID bedrockPlayer) throws IOException {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        JsonArray a = PlayerLinkController.getJson();
        for (JsonElement e : a) {
            PlayerLink l = gson.fromJson(e, PlayerLink.class);
            if (!l.discordID.equals(discordID) || !l.floodgateUUID.equals(bedrockPlayer.toString())) continue;
            return l;
        }
        return null;
    }

    @Nullable
    private static JsonElement getBedrockUserRaw(@Nonnull String discordID, @Nonnull UUID bedrockPlayer) throws IOException {
        if (!Variables.discord_instance.srv.isOnlineMode()) {
            return null;
        }
        JsonArray a = PlayerLinkController.getJson();
        for (JsonElement e : a) {
            PlayerLink l = gson.fromJson(e, PlayerLink.class);
            if (!l.discordID.equals(discordID) || !l.floodgateUUID.equals(bedrockPlayer.toString())) continue;
            return e;
        }
        return null;
    }

    @Nonnull
    private static JsonArray getJson() throws IOException, IllegalStateException {
        if (!playerLinkedFile.exists()) {
            playerLinkedFile.createNewFile();
            try (FileWriter writer = new FileWriter(playerLinkedFile);){
                gson.toJson((JsonElement)new JsonArray(), (Appendable)writer);
            }
            return new JsonArray();
        }
        FileReader is = new FileReader(playerLinkedFile);
        JsonArray a = parser.parse(is).getAsJsonArray();
        is.close();
        return a;
    }

    @Nonnull
    public static PlayerLink[] getAllLinks() {
        try {
            return gson.fromJson((JsonElement)PlayerLinkController.getJson(), PlayerLink[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new PlayerLink[0];
        }
    }
}

