/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.PatternReplacementResult;
import dcshadow.net.kyori.adventure.text.TextComponent;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;

public class ComponentUtils {
    @Nonnull
    public static Style addUserHoverClick(@Nonnull Style styleIn, @Nonnull Member m) {
        return ComponentUtils.addUserHoverClick(styleIn, m.getId(), m.getEffectiveName(), m.getUser().getAsTag());
    }

    @Nonnull
    public static Style addUserHoverClick(@Nonnull Style styleIn, @Nonnull User u, @Nullable Member m) {
        return ComponentUtils.addUserHoverClick(styleIn, u.getId(), m == null ? u.getName() : m.getEffectiveName(), u.getAsTag());
    }

    @Nonnull
    public static Style addUserHoverClick(@Nonnull Style styleIn, @Nonnull String userID, @Nonnull String displayName, @Nonnull String tag) {
        return styleIn.clickEvent(ClickEvent.suggestCommand("<@" + userID + ">")).hoverEvent(HoverEvent.showText(Component.text(Configuration.instance().localization.discordUserHover.replace("%user#tag%", tag).replace("%user%", displayName))));
    }

    @Nonnull
    public static Component makeURLsClickable(@Nonnull Component in) {
        return in.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(MessageUtils.URL_PATTERN).replacement(url -> (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)url.decorate(TextDecoration.UNDERLINED)).color(TextColor.color(6, 69, 173))).clickEvent(ClickEvent.openUrl(url.content()))).build());
    }

    @Nonnull
    public static TextReplacementConfig replace(@Nonnull String a, @Nonnull String b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).build();
    }

    @Nonnull
    public static TextReplacementConfig replaceLiteral(@Nonnull String a, @Nonnull String b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).build();
    }

    @Nonnull
    public static TextReplacementConfig replace(@Nonnull String a, @Nonnull String b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).times(times).build();
    }

    @Nonnull
    public static TextReplacementConfig replaceLiteral(@Nonnull String a, @Nonnull String b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).times(times).build();
    }

    @Nonnull
    public static TextReplacementConfig replace(@Nonnull String a, @Nonnull Component b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).build();
    }

    @Nonnull
    public static TextReplacementConfig replaceLiteral(@Nonnull String a, @Nonnull Component b) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).build();
    }

    @Nonnull
    public static TextReplacementConfig replace(@Nonnull String a, @Nonnull Component b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().match(a).replacement(b).times(times).build();
    }

    @Nonnull
    public static TextReplacementConfig replaceLiteral(@Nonnull String a, @Nonnull Component b, int times) {
        return (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(a).replacement(b).times(times).build();
    }

    @Nonnull
    public static Map.Entry<Boolean, Component> parsePing(@Nonnull Component msg, @Nonnull UUID uuid, @Nonnull String name) {
        AtomicBoolean hasPing = new AtomicBoolean(false);
        msg = msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + name).replacement(Component.text("@" + name).style(Style.style(TextColors.PING).decorate(TextDecoration.BOLD))).condition((a, b) -> {
            hasPing.set(true);
            return PatternReplacementResult.REPLACE;
        }).build());
        if (!hasPing.get() && PlayerLinkController.isPlayerLinked(uuid)) {
            String dcname = Variables.discord_instance.getChannel().getGuild().getMember(Variables.discord_instance.getJDA().getUserById(PlayerLinkController.getDiscordFromPlayer(uuid))).getEffectiveName();
            msg = msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("@" + dcname).replacement(Component.text("@" + dcname).style(Style.style(TextColors.PING).decorate(TextDecoration.BOLD))).condition((a, b) -> {
                hasPing.set(true);
                return PatternReplacementResult.REPLACE;
            }).build());
        }
        return new DefaultMapEntry<Boolean, Component>(hasPing.get(), msg);
    }

    @Nonnull
    public static Component append(Component base, Component toAppend) {
        return base.append(toAppend);
    }
}

