/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.club.minnced.discord.webhook.send.WebhookEmbed;
import dcshadow.club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import dcshadow.javax.annotation.Nonnull;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;

public final class DiscordMessage {
    private final boolean isNotRaw;
    private MessageEmbed embed;
    private String message = "";

    public DiscordMessage(MessageEmbed embed, @Nonnull String message, boolean isNotRaw) {
        this.embed = embed;
        this.message = message;
        this.isNotRaw = isNotRaw;
    }

    public DiscordMessage(MessageEmbed embed, @Nonnull String message) {
        this(embed, message, false);
    }

    public DiscordMessage(@Nonnull String message) {
        this(null, message, false);
    }

    public DiscordMessage(@Nonnull MessageEmbed embed) {
        this(embed, "", false);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public MessageEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(@Nonnull MessageEmbed embed) {
        this.embed = embed;
    }

    @Nonnull
    public Message buildMessage() {
        MessageBuilder out = new MessageBuilder();
        if (!this.message.isEmpty()) {
            if (this.isNotRaw) {
                if (Configuration.instance().messages.formattingCodesToDiscord) {
                    out.setContent(MessageUtils.convertMCToMarkdown(this.message));
                } else {
                    out.setContent(MessageUtils.removeFormatting(MessageUtils.convertMCToMarkdown(this.message)));
                }
            } else {
                out.setContent(this.message);
            }
        }
        if (this.embed != null) {
            out.setEmbed(this.embed);
        }
        return out.build();
    }

    @Nonnull
    public WebhookMessageBuilder buildWebhookMessage() {
        WebhookMessageBuilder out = new WebhookMessageBuilder();
        if (!this.message.isEmpty()) {
            if (this.isNotRaw) {
                if (Configuration.instance().messages.formattingCodesToDiscord) {
                    out.setContent(MessageUtils.convertMCToMarkdown(this.message));
                } else {
                    out.setContent(MessageUtils.removeFormatting(MessageUtils.convertMCToMarkdown(this.message)));
                }
            } else {
                out.setContent(this.message);
            }
        }
        if (this.embed != null) {
            WebhookEmbedBuilder eb = new WebhookEmbedBuilder();
            if (this.embed.getAuthor() != null) {
                eb.setAuthor(new WebhookEmbed.EmbedAuthor(this.embed.getAuthor().getName(), this.embed.getAuthor().getIconUrl(), this.embed.getAuthor().getUrl()));
            }
            eb.setColor(this.embed.getColorRaw());
            eb.setDescription(this.embed.getDescription());
            if (this.embed.getFooter() != null) {
                eb.setFooter(new WebhookEmbed.EmbedFooter(this.embed.getFooter().getText(), this.embed.getFooter().getIconUrl()));
            }
            if (this.embed.getImage() != null) {
                eb.setImageUrl(this.embed.getImage().getUrl());
            }
            if (this.embed.getThumbnail() != null) {
                eb.setThumbnailUrl(this.embed.getThumbnail().getUrl());
            }
            for (MessageEmbed.Field f : this.embed.getFields()) {
                eb.addField(new WebhookEmbed.EmbedField(f.isInline(), f.getName(), f.getValue()));
            }
            eb.setTimestamp(this.embed.getTimestamp());
            if (this.embed.getTitle() != null) {
                eb.setTitle(new WebhookEmbed.EmbedTitle(this.embed.getTitle(), this.embed.getUrl()));
            }
            out.addEmbeds(eb.build());
        }
        return out;
    }
}

