/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.com.google.gson.JsonArray;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.dev.vankka.mcdiscordreserializer.discord.DiscordSerializer;
import dcshadow.javax.annotation.Nonnull;
import dcshadow.javax.annotation.Nullable;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import dcshadow.org.apache.commons.lang3.time.DurationFormatUtils;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerSettings;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.time.Duration;
import java.time.Instant;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;

public class MessageUtils {
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern USER_PING_REGEX = Pattern.compile("(<@!?([0-9]{17,18})>)");
    private static final Pattern ROLE_PING_REGEX = Pattern.compile("(<@&([0-9]{17,20})>)");
    private static final Pattern CHANNEL_REGEX = Pattern.compile("(<#([0-9]{17,20})>)");
    private static final Pattern ANYPING_REGEX = Pattern.compile("(<..?([0-9]{17,20})>)");

    @Nonnull
    public static String[] makeStringArray(@Nonnull JsonArray channelID) {
        String[] out = new String[channelID.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = channelID.get(i).getAsString();
        }
        return out;
    }

    @Nullable
    public static String getDiscordName(@Nonnull UUID p) {
        if (Variables.discord_instance == null) {
            return null;
        }
        if (Configuration.instance().linking.enableLinking && PlayerLinkController.isPlayerLinked(p)) {
            PlayerSettings settings = PlayerLinkController.getSettings(null, p);
            if (settings.useDiscordNameInChannel) {
                return Variables.discord_instance.getChannel().getGuild().getMemberById(PlayerLinkController.getDiscordFromPlayer(p)).getEffectiveName();
            }
        }
        return null;
    }

    @Nonnull
    public static String escapeMarkdown(@Nonnull String in) {
        return in.replace("(?<!\\\\)[`*_|~]/g", "\\\\$0");
    }

    @Nonnull
    public static String escapeMarkdownCodeBlocks(@Nonnull String in) {
        return in.replace("(?<!\\\\)`/g", "\\\\$0");
    }

    @Nonnull
    public static String getFullUptime() {
        if (Variables.started == 0L) {
            return "?????";
        }
        Duration duration = Duration.between(Instant.ofEpochMilli(Variables.started), Instant.now());
        return DurationFormatUtils.formatDuration(duration.toMillis(), Configuration.instance().localization.commands.uptimeFormat);
    }

    @Nonnull
    public static String convertMCToMarkdown(@Nonnull String in) {
        if (!Configuration.instance().messages.convertCodes) {
            if (Configuration.instance().messages.formattingCodesToDiscord) {
                return in;
            }
            return MessageUtils.removeFormatting(in);
        }
        in = MessageUtils.escapeMarkdownCodeBlocks(in);
        try {
            return DiscordSerializer.INSTANCE.serialize(LegacyComponentSerializer.legacySection().deserialize(in));
        }
        catch (NullPointerException | ConcurrentModificationException ex) {
            ex.printStackTrace();
            return in;
        }
    }

    @Nonnull
    public static String removeFormatting(@Nonnull String text) {
        return FORMATTING_CODE_PATTERN.matcher(text).replaceAll("");
    }

    @Nonnull
    public static Component mentionsToNames(@Nonnull Component in, @Nonnull Guild targetGuild) {
        in = in.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(ANYPING_REGEX).replacement((result, builder) -> {
            builder.content(MessageUtils.mentionsToNames(builder.content(), targetGuild));
            return builder;
        }).build());
        return in;
    }

    @Nonnull
    public static String mentionsToNames(@Nonnull String in, @Nonnull Guild targetGuild) {
        String id;
        String str;
        JDA jda = Variables.discord_instance.getJDA();
        if (jda == null) {
            return in;
        }
        Matcher userMatcher = USER_PING_REGEX.matcher(in);
        Matcher roleMatcher = ROLE_PING_REGEX.matcher(in);
        Matcher channelMatcher = CHANNEL_REGEX.matcher(in);
        while (userMatcher.find()) {
            str = userMatcher.group(1);
            id = userMatcher.group(2);
            User u = jda.getUserById(id);
            if (u == null) continue;
            Member m = targetGuild.getMember(u);
            String name = m != null ? m.getEffectiveName() : u.getName();
            in = in.replace(str, "@" + name);
        }
        while (roleMatcher.find()) {
            str = roleMatcher.group(1);
            id = roleMatcher.group(2);
            Role role = targetGuild.getRoleById(id);
            if (role == null) continue;
            in = in.replace(str, "@" + role.getName());
        }
        while (channelMatcher.find()) {
            str = channelMatcher.group(1);
            id = channelMatcher.group(2);
            TextChannel channel = targetGuild.getTextChannelById(id);
            if (channel == null) continue;
            in = in.replace(str, "#" + channel.getName());
        }
        return in;
    }

    @Nonnull
    public static String formatEmoteMessage(@Nonnull List<Emote> emotes, @Nonnull String msg) {
        msg = EmojiParser.parseToAliases(msg);
        for (Emote e : emotes) {
            msg = msg.replace(e.toString(), ":" + e.getName() + ":");
        }
        return msg;
    }

    @Nullable
    public static String getNameFromUUID(@Nonnull UUID uuid) {
        String name = Variables.discord_instance.srv.getNameFromUUID(uuid);
        return name == null || name.isEmpty() ? null : name;
    }
}

