/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.com.google.gson.JsonArray;
import dcshadow.com.google.gson.JsonObject;
import dcshadow.com.google.gson.JsonParser;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class UpdateChecker {
    public static final String updateCheckerURL = "https://raw.githubusercontent.com/ErdbeerbaerLP/Discord-Chat-Integration/1.16/update_checker.json";
    private static final JsonParser p = new JsonParser();

    public static void runUpdateCheck() {
        if (!Configuration.instance().general.enableUpdateChecker) {
            return;
        }
        StringBuilder changelog = new StringBuilder();
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(updateCheckerURL).openConnection();
            conn.setRequestMethod("GET");
            InputStreamReader r = new InputStreamReader(conn.getInputStream());
            JsonArray parse = p.parse(r).getAsJsonArray();
            if (parse == null) {
                System.err.println("Could not check for updates");
                return;
            }
            AtomicBoolean shouldNotify = new AtomicBoolean(false);
            AtomicInteger versionsBehind = new AtomicInteger();
            parse.forEach(elm -> {
                if (elm != null && elm.isJsonObject()) {
                    JsonObject versionDetails = elm.getAsJsonObject();
                    String version = versionDetails.get("version").getAsString();
                    try {
                        if (Integer.parseInt(version.replace(".", "")) > Integer.parseInt("2.1.1".replace(".", ""))) {
                            versionsBehind.getAndIncrement();
                            changelog.append("\n").append(version).append(":\n").append(versionDetails.get("changelog").getAsString()).append("\n");
                            if (!shouldNotify.get() && ReleaseType.getFromName((String)versionDetails.get((String)"type").getAsString()).value >= Configuration.instance().general.updateCheckerMinimumReleaseType.value) {
                                shouldNotify.set(true);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            });
            String changelogString = changelog.toString();
            if (shouldNotify.get()) {
                System.out.println("[Discord Integration] Updates available! You are " + versionsBehind.get() + " version" + (versionsBehind.get() == 1 ? "" : "s") + " behind\nChangelog since last update:\n" + changelogString);
            }
        }
        catch (IOException e) {
            System.out.println("Could not check for updates");
            e.printStackTrace();
        }
    }

    public static enum ReleaseType {
        alpha(0),
        beta(1),
        release(2);

        public final int value;

        private ReleaseType(int val) {
            this.value = val;
        }

        public static ReleaseType getFromName(String name) {
            for (ReleaseType t : ReleaseType.values()) {
                if (!name.toLowerCase().equals(t.name().toLowerCase())) continue;
                return t;
            }
            return beta;
        }
    }
}

