/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.Discord;
import de.erdbeerbaerlp.dcintegration.common.compat.DynmapListener;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.UpdateChecker;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import de.erdbeerbaerlp.dcintegration.forge.api.ForgeDiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.forge.command.McCommandDiscord;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeMessageUtils;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeServerInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="dcintegration")
public class DiscordIntegration {
    public static final String MODID = "dcintegration";
    public static final ArrayList<UUID> timeouts = new ArrayList();
    private boolean stopped = false;

    public DiscordIntegration() {
        Configuration.instance().loadConfig();
        if (!Configuration.instance().general.botToken.equals("INSERT BOT TOKEN HERE") && FMLEnvironment.dist != Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
            MinecraftForge.EVENT_BUS.register((Object)this);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        } else {
            System.err.println("Please check the config file and set an bot token");
        }
        File linkedOld = new File("./linkedPlayers.json");
        File linkedNew = new File(Variables.discordDataDir, "LinkedPlayers.json");
        File ignoreOld = new File("./players_ignoring_discord_v2");
        File ignoreNew = new File(Variables.discordDataDir, ".PlayerIgnores");
        if (!Variables.discordDataDir.exists()) {
            Variables.discordDataDir.mkdir();
        }
        if (linkedOld.exists() && !linkedNew.exists()) {
            linkedOld.renameTo(linkedNew);
        }
        if (ignoreOld.exists() && !ignoreNew.exists()) {
            ignoreOld.renameTo(ignoreNew);
        }
    }

    public void serverSetup(FMLDedicatedServerSetupEvent ev) {
        CommandRegistry.registerDefaultCommandsFromConfig();
        Variables.discord_instance = new Discord(new ForgeServerInterface());
        try {
            System.out.println("Waiting for JDA to initialize to send starting message... (max 5 seconds before skipping)");
            for (int i = 0; i <= 5 && Variables.discord_instance.getJDA() == null; ++i) {
                Thread.sleep(1000L);
            }
            if (Variables.discord_instance.getJDA() != null && !Configuration.instance().localization.serverStarting.isEmpty()) {
                Thread.sleep(2000L);
                if (Variables.discord_instance.getChannel() != null) {
                    Variables.startingMsg = Variables.discord_instance.sendMessageReturns(Configuration.instance().localization.serverStarting, Variables.discord_instance.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        }
        catch (InterruptedException | NullPointerException exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (PlayerLinkController.getSettings(null, (UUID)ev.getPlayer().func_110124_au()).hideFromDiscord) {
            return;
        }
        if (Variables.discord_instance != null) {
            Variables.discord_instance.sendMessage(Configuration.instance().localization.playerJoin.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer())));
            Thread fixLinkStatus = new Thread(() -> {
                Member member;
                if (Configuration.instance().linking.linkedRoleID.equals("0")) {
                    return;
                }
                UUID uuid = ev.getPlayer().func_110124_au();
                if (!PlayerLinkController.isPlayerLinked(uuid)) {
                    return;
                }
                Guild guild = Variables.discord_instance.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                if (PlayerLinkController.isPlayerLinked(uuid) && !(member = guild.getMemberById(PlayerLinkController.getDiscordFromPlayer(uuid))).getRoles().contains(linkedRole)) {
                    guild.addRoleToMember(member, linkedRole).queue();
                }
            });
            fixLinkStatus.setDaemon(true);
            fixLinkStatus.start();
        }
    }

    @SubscribeEvent
    public void advancement(AdvancementEvent ev) {
        if (PlayerLinkController.getSettings(null, (UUID)ev.getPlayer().func_110124_au()).hideFromDiscord) {
            return;
        }
        if (Variables.discord_instance != null && ev.getAdvancement() != null && ev.getAdvancement().func_192068_c() != null && ev.getAdvancement().func_192068_c().func_193220_i()) {
            Variables.discord_instance.sendMessage(Configuration.instance().localization.advancementMessage.replace("%player%", TextFormatting.func_110646_a((String)ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer()))).replace("%name%", TextFormatting.func_110646_a((String)ev.getAdvancement().func_192068_c().func_192297_a().getString())).replace("%desc%", TextFormatting.func_110646_a((String)ev.getAdvancement().func_192068_c().func_193222_b().getString())).replace("\\n", "\n"));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent ev) {
        new McCommandDiscord((CommandDispatcher<CommandSource>)ev.getDispatcher());
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent ev) {
        System.out.println("Started");
        Variables.started = new Date().getTime();
        if (Variables.discord_instance != null) {
            if (Variables.startingMsg != null) {
                Variables.startingMsg.thenAccept(a -> a.editMessage(Configuration.instance().localization.serverStarted).queue());
            } else {
                Variables.discord_instance.sendMessage(Configuration.instance().localization.serverStarted);
            }
        }
        if (Variables.discord_instance != null) {
            Variables.discord_instance.startThreads();
        }
        UpdateChecker.runUpdateCheck();
        if (ModList.get().getModContainerById("dynmap").isPresent()) {
            new DynmapListener().register();
        }
    }

    @SubscribeEvent
    public void command(CommandEvent ev) {
        String command = ev.getParseResults().getReader().getString().replaceFirst(Pattern.quote("/"), "");
        if (!Configuration.instance().commandLog.channelID.equals("0") && !ArrayUtils.contains((Object[])Configuration.instance().commandLog.ignoredCommands, (Object)command.split(" ")[0])) {
            Variables.discord_instance.sendMessage(Configuration.instance().commandLog.message.replace("%sender%", ((CommandSource)ev.getParseResults().getContext().getLastChild().getSource()).func_197037_c()).replace("%cmd%", command).replace("%cmd-no-args%", command.split(" ")[0]), Variables.discord_instance.getChannel(Configuration.instance().commandLog.channelID));
        }
        if (Variables.discord_instance != null) {
            boolean raw = false;
            if (command.startsWith("say") && Configuration.instance().messages.sendOnSayCommand || command.startsWith("me") && Configuration.instance().messages.sendOnMeCommand) {
                String msg = command.replace("say ", "");
                if (command.startsWith("say")) {
                    msg = msg.replaceFirst("say ", "");
                }
                if (command.startsWith("me")) {
                    raw = true;
                    msg = "*" + MessageUtils.escapeMarkdown(msg.replaceFirst("me ", "").trim()) + "*";
                }
                try {
                    Variables.discord_instance.sendMessage(((CommandSource)ev.getParseResults().getContext().getSource()).func_197037_c(), ((CommandSource)ev.getParseResults().getContext().getSource()).func_197027_g().func_110124_au().toString(), new DiscordMessage(null, msg, !raw), Variables.discord_instance.getChannel(Configuration.instance().advanced.chatOutputChannelID));
                }
                catch (CommandSyntaxException e) {
                    if (msg.startsWith(Configuration.instance().messages.sayCommandIgnoredPrefix)) {
                        return;
                    }
                    Variables.discord_instance.sendMessage(msg);
                }
            }
        }
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent ev) {
        if (Variables.discord_instance != null) {
            Variables.discord_instance.sendMessage(Configuration.instance().localization.serverStopped);
            Variables.discord_instance.stopThreads();
        }
        this.stopped = true;
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent ev) {
        if (Variables.discord_instance != null) {
            if (!this.stopped && Variables.discord_instance.getJDA() != null) {
                ev.getServer().func_213167_f(() -> {
                    Variables.discord_instance.stopThreads();
                    try {
                        Variables.discord_instance.sendMessageReturns(Configuration.instance().localization.serverCrash, Variables.discord_instance.getChannel(Configuration.instance().advanced.serverChannelID)).get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                });
            }
            Variables.discord_instance.kill();
        }
    }

    private boolean isModIDBlacklisted(String sender) {
        return ArrayUtils.contains((Object[])Configuration.instance().forgeSpecific.IMC_modIdBlacklist, (Object)sender);
    }

    @SubscribeEvent
    public void imc(InterModProcessEvent ev) {
        Stream stream = ev.getIMCStream();
        stream.forEach(msg -> {
            System.out.println("[IMC-Message] Sender: " + msg.getSenderModId() + " method: " + msg.getMethod());
            if (this.isModIDBlacklisted(msg.getSenderModId())) {
                return;
            }
            if (msg.getMethod().equals("Discord-Message") || msg.getMethod().equals("sendMessage")) {
                Variables.discord_instance.sendMessage(msg.getMessageSupplier().get().toString());
            }
        });
    }

    @SubscribeEvent
    public void chat(ServerChatEvent ev) {
        if (PlayerLinkController.getSettings(null, (UUID)ev.getPlayer().func_110124_au()).hideFromDiscord) {
            return;
        }
        ITextComponent msg = ev.getComponent();
        if (Variables.discord_instance.callEvent(e -> {
            if (e instanceof ForgeDiscordEventHandler) {
                return ((ForgeDiscordEventHandler)e).onMcChatMessage(ev);
            }
            return false;
        })) {
            return;
        }
        String text = MessageUtils.escapeMarkdown(ev.getMessage().replace("@everyone", "[at]everyone").replace("@here", "[at]here"));
        MessageEmbed embed = ForgeMessageUtils.genItemStackEmbedIfAvailable(msg);
        if (Variables.discord_instance != null) {
            TextChannel channel = Variables.discord_instance.getChannel(Configuration.instance().advanced.chatOutputChannelID);
            if (channel == null) {
                return;
            }
            Variables.discord_instance.sendMessage(ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer()), ev.getPlayer().func_110124_au().toString(), new DiscordMessage(embed, text, true), channel);
            String json = ITextComponent.Serializer.func_150696_a((ITextComponent)msg);
            Object comp = GsonComponentSerializer.gson().deserialize(json);
            String editedJson = (String)GsonComponentSerializer.gson().serialize(MessageUtils.mentionsToNames(comp, channel.getGuild()));
            ev.setComponent((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)editedJson));
        }
    }

    @SubscribeEvent
    public void death(LivingDeathEvent ev) {
        if (PlayerLinkController.getSettings(null, (UUID)ev.getEntity().func_110124_au()).hideFromDiscord) {
            return;
        }
        if ((ev.getEntity() instanceof PlayerEntity || ev.getEntity() instanceof TameableEntity && ((TameableEntity)ev.getEntity()).func_70902_q() instanceof PlayerEntity && Configuration.instance().messages.sendDeathMessagesForTamedAnimals) && Variables.discord_instance != null) {
            ITextComponent deathMessage = ev.getSource().func_151519_b(ev.getEntityLiving());
            MessageEmbed embed = ForgeMessageUtils.genItemStackEmbedIfAvailable(deathMessage);
            Variables.discord_instance.sendMessage(new DiscordMessage(embed, Configuration.instance().localization.playerDeath.replace("%player%", ForgeMessageUtils.formatPlayerName(ev.getEntity())).replace("%msg%", TextFormatting.func_110646_a((String)deathMessage.getString()).replace(ev.getEntity().func_200200_C_().func_150261_e() + " ", ""))), Variables.discord_instance.getChannel(Configuration.instance().advanced.deathsChannelID));
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (this.stopped) {
            return;
        }
        if (PlayerLinkController.getSettings(null, (UUID)ev.getPlayer().func_110124_au()).hideFromDiscord) {
            return;
        }
        if (Variables.discord_instance != null && !timeouts.contains(ev.getPlayer().func_110124_au())) {
            Variables.discord_instance.sendMessage(Configuration.instance().localization.playerLeave.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer())));
        } else if (Variables.discord_instance != null && timeouts.contains(ev.getPlayer().func_110124_au())) {
            Variables.discord_instance.sendMessage(Configuration.instance().localization.playerTimeout.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer())));
            timeouts.remove(ev.getPlayer().func_110124_au());
        }
    }
}

