/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.command;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import java.util.UUID;
import net.dv8tion.jda.api.entities.User;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DCCommandSender
extends FakePlayer {
    private static final UUID uuid = UUID.fromString(Configuration.instance().commands.senderUUID);
    private final String channelID;

    public DCCommandSender(User user, String channel) {
        super(ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_), new GameProfile(uuid, "@" + user.getName() + "#" + user.getDiscriminator()));
        this.channelID = channel;
    }

    public DCCommandSender(ServerWorld world, String name, String channel) {
        super(world, new GameProfile(uuid, "@" + name));
        this.channelID = channel;
    }

    private static String textComponentToDiscordMessage(ITextComponent component) {
        if (component == null) {
            return "";
        }
        return MessageUtils.convertMCToMarkdown(component.getString());
    }

    public void func_145747_a(ITextComponent textComponent, UUID uuid) {
        Variables.discord_instance.sendMessageFuture(DCCommandSender.textComponentToDiscordMessage(textComponent), this.channelID);
    }

    public boolean func_195039_a() {
        return true;
    }

    public boolean func_195040_b() {
        return true;
    }

    public void func_146105_b(ITextComponent component, boolean actionBar) {
        Preconditions.checkNotNull((Object)component);
        Variables.discord_instance.sendMessageFuture(DCCommandSender.textComponentToDiscordMessage(component), this.channelID);
    }
}

