/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class ForgeMessageUtils
extends MessageUtils {
    private static final JsonParser p = new JsonParser();
    private static final IForgeRegistry<Item> itemreg = GameRegistry.findRegistry(Item.class);

    public static String formatPlayerName(Map.Entry<UUID, String> p) {
        return ForgeMessageUtils.formatPlayerName(p, true);
    }

    public static String formatPlayerName(Map.Entry<UUID, String> p, boolean chatFormat) {
        return TextFormatting.func_110646_a((String)p.getValue());
    }

    public static MessageEmbed genItemStackEmbedIfAvailable(ITextComponent component) {
        if (!Configuration.instance().forgeSpecific.sendItemInfo) {
            return null;
        }
        JsonObject json = p.parse(ITextComponent.Serializer.func_150696_a((ITextComponent)component)).getAsJsonObject();
        System.out.println("Generating embed...");
        System.out.println("JSON: " + json);
        if (json.has("with")) {
            JsonArray args2 = json.getAsJsonArray("with");
            for (JsonElement el : args2) {
                JsonObject hoverEvent;
                JsonObject arg1;
                if (!(el instanceof JsonObject) || !(arg1 = (JsonObject)el).has("hoverEvent") || !(hoverEvent = arg1.getAsJsonObject("hoverEvent")).has("action") || !hoverEvent.get("action").getAsString().equals("show_item") || !hoverEvent.has("contents") || !hoverEvent.getAsJsonObject("contents").has("tag")) continue;
                JsonObject item = hoverEvent.getAsJsonObject("contents").getAsJsonObject();
                try {
                    ItemStack is = new ItemStack((IItemProvider)itemreg.getValue(new ResourceLocation(item.get("id").getAsString())));
                    if (item.has("tag")) {
                        CompoundNBT tag = NBTCompoundTagArgument.func_218043_a().parse(new StringReader(item.get("tag").getAsString()));
                        is.func_77982_d(tag);
                    }
                    CompoundNBT itemTag = is.func_196082_o();
                    EmbedBuilder b = new EmbedBuilder();
                    b.setTitle(is.func_82837_s() ? is.func_200301_q().func_150261_e() : new TranslationTextComponent(is.func_77977_a()).func_150261_e());
                    b.setFooter(is.func_77973_b().getRegistryName().toString());
                    StringBuilder tooltip = new StringBuilder();
                    boolean[] flags = new boolean[6];
                    Arrays.fill(flags, false);
                    if (itemTag.func_74764_b("HideFlags")) {
                        int input = itemTag.func_74762_e("HideFlags");
                        for (int i = 0; i < flags.length; ++i) {
                            flags[i] = (input & 1 << i) != 0;
                        }
                    }
                    if (!flags[0]) {
                        for (int i = 0; i < is.func_77986_q().size(); ++i) {
                            CompoundNBT compoundnbt = is.func_77986_q().func_150305_b(i);
                            Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"))).ifPresent(ench -> {
                                if (compoundnbt.func_74781_a("lvl") != null) {
                                    int level = compoundnbt.func_74781_a("lvl") instanceof StringNBT ? Integer.parseInt(compoundnbt.func_74779_i("lvl").replace("s", "")) : (compoundnbt.func_74762_e("lvl") == 0 ? compoundnbt.func_74765_d("lvl") : compoundnbt.func_74762_e("lvl"));
                                    tooltip.append(TextFormatting.func_110646_a((String)ench.func_200305_d(level).getString())).append("\n");
                                }
                            });
                        }
                    }
                    ListNBT list = itemTag.func_74775_l("display").func_150295_c("Lore", 8);
                    list.forEach(nbt -> {
                        try {
                            if (nbt instanceof StringNBT) {
                                TextComponent comp = (TextComponent)ComponentArgument.func_197067_a().parse(new StringReader(nbt.func_150285_a_()));
                                tooltip.append("_").append(comp.func_150261_e()).append("_\n");
                            }
                        }
                        catch (CommandSyntaxException e) {
                            e.printStackTrace();
                        }
                    });
                    if (!flags[2] && itemTag.func_74764_b("Unbreakable") && itemTag.func_74767_n("Unbreakable")) {
                        tooltip.append("Unbreakable\n");
                    }
                    b.setDescription(tooltip.toString());
                    return b.build();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                }
            }
        }
        return null;
    }

    public static String formatPlayerName(Entity p) {
        DefaultMapEntry<UUID, String> e = new DefaultMapEntry<UUID, String>(p.func_110124_au(), p.func_145748_c_().func_150261_e().isEmpty() ? p.func_200200_C_().func_150261_e() : p.func_145748_c_().func_150261_e());
        return ForgeMessageUtils.formatPlayerName(e);
    }
}

