/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializer;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordEventListener;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.PlayerLinkController;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.ServerInterface;
import de.erdbeerbaerlp.dcintegration.common.util.Variables;
import de.erdbeerbaerlp.dcintegration.forge.command.DCCommandSender;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeMessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ForgeServerInterface
extends ServerInterface {
    @Override
    public int getMaxPlayers() {
        return ServerLifecycleHooks.getCurrentServer() == null ? -1 : ServerLifecycleHooks.getCurrentServer().func_71275_y();
    }

    @Override
    public int getOnlinePlayers() {
        return ServerLifecycleHooks.getCurrentServer() == null ? -1 : ServerLifecycleHooks.getCurrentServer().func_71213_z().length;
    }

    @Override
    public void sendMCMessage(Component msg) {
        List l = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        try {
            for (ServerPlayerEntity p : l) {
                if (Variables.discord_instance.ignoringPlayers.contains(p.func_110124_au()) || PlayerLinkController.isPlayerLinked(p.func_110124_au()) && PlayerLinkController.getSettings(null, (UUID)p.func_110124_au()).ignoreDiscordChatIngame) continue;
                Map.Entry<Boolean, Component> ping = ComponentUtils.parsePing(msg, p.func_110124_au(), p.func_200200_C_().func_150261_e());
                String jsonComp = ((String)GsonComponentSerializer.gson().serialize(ping.getValue())).replace("\\\\n", "\n");
                ITextComponent comp = ComponentArgument.func_197067_a().parse(new StringReader(jsonComp));
                p.func_145747_a(comp, Util.field_240973_b_);
                if (!ping.getKey().booleanValue() || !PlayerLinkController.getSettings(null, (UUID)p.func_110124_au()).pingSound) continue;
                p.field_71135_a.func_147359_a((IPacket)new SPlaySoundPacket(SoundEvents.field_189107_dL.getRegistryName(), SoundCategory.MASTER, new Vector3d(p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_()), 1.0f, 1.0f));
            }
            String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msg)).replace("\\\\n", "\n");
            ITextComponent comp = ComponentArgument.func_197067_a().parse(new StringReader(jsonComp));
            ServerLifecycleHooks.getCurrentServer().func_145747_a(comp, Util.field_240973_b_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendMCReaction(Member member, RestAction<Message> retrieveMessage, UUID targetUUID, MessageReaction.ReactionEmote reactionEmote) {
        List l = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity p : l) {
            if (!p.func_110124_au().equals(targetUUID) || Variables.discord_instance.ignoringPlayers.contains(p.func_110124_au()) || PlayerLinkController.getSettings(null, (UUID)p.func_110124_au()).ignoreDiscordChatIngame || PlayerLinkController.getSettings(null, (UUID)p.func_110124_au()).ignoreReactions) continue;
            String emote = reactionEmote.isEmote() ? ":" + reactionEmote.getEmote().getName() + ":" : MessageUtils.formatEmoteMessage(new ArrayList<Emote>(), reactionEmote.getEmoji());
            String outMsg = Configuration.instance().localization.reactionMessage.replace("%name%", member.getEffectiveName()).replace("%name2%", member.getUser().getAsTag()).replace("%emote%", emote);
            if (Configuration.instance().localization.reactionMessage.contains("%msg%")) {
                retrieveMessage.submit().thenAccept(m -> {
                    String outMsg2 = outMsg.replace("%msg%", m.getContentDisplay());
                    this.sendReactionMCMessage(p, ForgeMessageUtils.formatEmoteMessage(m.getEmotes(), outMsg2));
                });
                continue;
            }
            this.sendReactionMCMessage(p, outMsg);
        }
    }

    @Override
    public void runMcCommand(String cmd, MessageReceivedEvent cmdMsg) {
        DCCommandSender s = new DCCommandSender(cmdMsg.getAuthor(), cmdMsg.getTextChannel().getId());
        if (s.func_211513_k(4)) {
            try {
                ServerLifecycleHooks.getCurrentServer().func_195571_aL().func_197054_a().execute(cmd.trim(), (Object)s.func_195051_bN());
            }
            catch (CommandSyntaxException e) {
                Variables.discord_instance.sendMessage(e.getMessage());
            }
        } else {
            Variables.discord_instance.sendMessage("Sorry, but the bot has no permissions...\nAdd this into the servers ops.json:\n```json\n {\n   \"uuid\": \"" + Configuration.instance().commands.senderUUID + "\",\n   \"name\": \"DiscordFakeUser\",\n   \"level\": 4,\n   \"bypassesPlayerLimit\": false\n }\n```", cmdMsg.getTextChannel());
        }
    }

    @Override
    public HashMap<UUID, String> getPlayers() {
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        for (ServerPlayerEntity p : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            players.put(p.func_110124_au(), p.func_145748_c_().func_150261_e().isEmpty() ? p.func_200200_C_().func_150261_e() : p.func_145748_c_().func_150261_e());
        }
        return players;
    }

    @Override
    public void sendMCMessage(String msg, UUID player) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(player).func_145747_a((ITextComponent)new StringTextComponent(msg), Util.field_240973_b_);
    }

    @Override
    public boolean isOnlineMode() {
        return Configuration.instance().bungee.isBehindBungee || ServerLifecycleHooks.getCurrentServer().func_71266_T();
    }

    private void sendReactionMCMessage(ServerPlayerEntity target, String msg) {
        Component msgComp = MinecraftSerializer.INSTANCE.serialize(msg.replace("\n", "\\n"), DiscordEventListener.mcSerializerOptions);
        String jsonComp = ((String)GsonComponentSerializer.gson().serialize(msgComp)).replace("\\\\n", "\n");
        try {
            ITextComponent comp = ComponentArgument.func_197067_a().parse(new StringReader(jsonComp));
            target.func_145747_a(comp, Util.field_240973_b_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getNameFromUUID(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().func_147130_as().fillProfileProperties(new GameProfile(uuid, ""), false).getName();
    }
}

