/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import dcshadow.org.jetbrains.annotations.Contract;
import java.util.Collection;
import net.dv8tion.jda.internal.utils.Helpers;

public class Checks {
    @Contract(value="null -> fail")
    public static void isSnowflake(String snowflake) {
        Checks.isSnowflake(snowflake, snowflake);
    }

    @Contract(value="null, _ -> fail")
    public static void isSnowflake(String snowflake, String message) {
        Checks.notNull(snowflake, message);
        if (snowflake.length() > 20 || !Helpers.isNumeric(snowflake)) {
            throw new IllegalArgumentException(message + " is not a valid snowflake value!");
        }
    }

    @Contract(value="false, _ -> fail")
    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void check(boolean expression, String message, Object ... args2) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args2));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void check(boolean expression, String message, Object arg) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, arg));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.isEmpty(argument)) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notBlank(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.isBlank(argument)) {
            throw new IllegalArgumentException(name + " may not be blank");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void noWhitespace(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.containsWhitespace(argument)) {
            throw new IllegalArgumentException(name + " may not contain blanks");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(Collection<?> argument, String name) {
        Checks.notNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(Object[] argument, String name) {
        Checks.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void noneNull(Collection<?> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notNull(it, name));
    }

    @Contract(value="null, _ -> fail")
    public static void noneNull(Object[] argument, String name) {
        Checks.notNull(argument, name);
        for (Object it : argument) {
            Checks.notNull(it, name);
        }
    }

    @Contract(value="null, _ -> fail")
    public static <T extends CharSequence> void noneEmpty(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notEmpty(it, name));
    }

    @Contract(value="null, _ -> fail")
    public static <T extends CharSequence> void noneBlank(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notBlank(it, name));
    }

    @Contract(value="null, _ -> fail")
    public static <T extends CharSequence> void noneContainBlanks(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.noWhitespace(it, name));
    }

    public static void positive(int n, String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " may not be negative or zero");
        }
    }

    public static void positive(long n, String name) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name + " may not be negative or zero");
        }
    }

    public static void notNegative(int n, String name) {
        if (n < 0) {
            throw new IllegalArgumentException(name + " may not be negative");
        }
    }

    public static void notNegative(long n, String name) {
        if (n < 0L) {
            throw new IllegalArgumentException(name + " may not be negative");
        }
    }
}

