/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors;

import de.castcrafter.travel_anchors.TeleportHandler;
import de.castcrafter.travel_anchors.TravelAnchors;
import de.castcrafter.travel_anchors.config.ClientConfig;
import de.castcrafter.travel_anchors.network.ClientEventSerializer;
import io.github.noeppi_noeppi.libx.event.ClickBlockEmptyHandEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getPlayer());
    }

    @SubscribeEvent
    public void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getPlayer());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (TeleportHandler.canPlayerTeleport(player, event.getHand()) && !event.getItemStack().func_190926_b()) {
            if (player.func_225608_bj_() && TeleportHandler.canItemTeleport(player, event.getHand())) {
                if (TeleportHandler.shortTeleport(world, player, event.getHand())) {
                    event.setResult(Event.Result.DENY);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    player.func_184811_cZ().func_185145_a(event.getItemStack().func_77973_b(), 30);
                }
            } else if (TeleportHandler.anchorTeleport(world, player, player.func_233580_cy_().func_185334_h().func_177977_b(), event.getHand())) {
                event.setResult(Event.Result.DENY);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onEmptyClick(PlayerInteractEvent.RightClickEmpty event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (TeleportHandler.canBlockTeleport(player) && !player.func_225608_bj_() && event.getHand() == Hand.MAIN_HAND && event.getPlayer().func_184586_b(Hand.OFF_HAND).func_190926_b() && event.getItemStack().func_190926_b()) {
            TravelAnchors.getNetwork().sendClientEventToServer(world, ClientEventSerializer.ClientEvent.EMPTY_HAND_INTERACT);
            event.setResult(Event.Result.DENY);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public void emptyBlockClick(ClickBlockEmptyHandEvent event) {
        if (event.getHand() == Hand.MAIN_HAND && TeleportHandler.canPlayerTeleport((PlayerEntity)event.getPlayer(), event.getHand()) && !event.getPlayer().func_225608_bj_() && TeleportHandler.anchorTeleport(event.getWorld(), (PlayerEntity)event.getPlayer(), event.getPlayer().func_233580_cy_().func_185334_h().func_177977_b(), event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (((Boolean)ClientConfig.DISABLE_ELEVATE.get()).booleanValue()) {
                if (TeleportHandler.canBlockTeleport(player) && !player.func_225608_bj_()) {
                    TravelAnchors.getNetwork().sendClientEventToServer(player.func_130014_f_(), ClientEventSerializer.ClientEvent.JUMP_TP);
                }
            } else if (TeleportHandler.canElevate(player) && !player.func_225608_bj_()) {
                TravelAnchors.getNetwork().sendClientEventToServer(player.func_130014_f_(), ClientEventSerializer.ClientEvent.JUMP);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onSneak(InputUpdateEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151468_f() && !((Boolean)ClientConfig.DISABLE_ELEVATE.get()).booleanValue() && TeleportHandler.canElevate((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            TravelAnchors.getNetwork().sendClientEventToServer(Minecraft.func_71410_x().field_71439_g.func_130014_f_(), ClientEventSerializer.ClientEvent.SNEAK);
        }
    }
}

