/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.castcrafter.travel_anchors.TravelAnchors;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public static final ForgeConfigSpec SERVER_CONFIG;
    private static final ForgeConfigSpec.Builder SERVER_BUILDER;
    public static ForgeConfigSpec.DoubleValue MAX_ANGLE;
    public static ForgeConfigSpec.DoubleValue MAX_DISTANCE;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("travel-anchor-settings");
        MAX_ANGLE = builder.comment(new String[]{"The maximum angle you can look at the Travel Anchor to teleport.", "Be sure to write a .0 after a whole number because forges config system can not handle whole numbers without it."}).defineInRange("maxAngle", 30.0, 1.0, Double.MAX_VALUE);
        MAX_DISTANCE = builder.comment(new String[]{"The maximum distance you are allowed to teleport.", "Be sure to write a .0 after a whole number because forges config system can not handle whole numbers without it."}).defineInRange("maxDistance", 64.0, 1.0, Double.MAX_VALUE);
        builder.pop();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        TravelAnchors.getInstance().logger.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        SERVER_BUILDER = new ForgeConfigSpec.Builder();
        ServerConfig.init(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

