/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors.network;

import de.castcrafter.travel_anchors.TravelAnchorList;
import de.castcrafter.travel_anchors.network.AnchorListUpdateHandler;
import de.castcrafter.travel_anchors.network.AnchorListUpdateSerializer;
import de.castcrafter.travel_anchors.network.AnchorNameChangeHandler;
import de.castcrafter.travel_anchors.network.AnchorNameChangeSerializer;
import de.castcrafter.travel_anchors.network.ClientEventHandler;
import de.castcrafter.travel_anchors.network.ClientEventSerializer;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

public class Networking
extends NetworkX {
    public Networking(ModX mod) {
        super(mod);
    }

    protected String getProtocolVersion() {
        return "5";
    }

    protected void registerPackets() {
        this.register(new AnchorNameChangeSerializer(), () -> AnchorNameChangeHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new AnchorListUpdateSerializer(), () -> AnchorListUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ClientEventSerializer(), () -> ClientEventHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void sendNameChange(World world, BlockPos pos, String name) {
        if (world.field_72995_K) {
            this.instance.sendToServer((Object)new AnchorNameChangeSerializer.AnchorNameChangeMessage(pos, name));
        }
    }

    public void updateTravelAnchorList(World world, @Nullable TravelAnchorList list) {
        if (!world.field_72995_K) {
            if (list == null) {
                list = TravelAnchorList.get(world);
            }
            this.instance.send(PacketDistributor.DIMENSION.with(() -> ((World)world).func_234923_W_()), (Object)new AnchorListUpdateSerializer.AnchorListUpdateMessage(list.func_189551_b(new CompoundNBT())));
        }
    }

    public void updateTravelAnchorList(PlayerEntity player) {
        if (!player.func_130014_f_().field_72995_K && player instanceof ServerPlayerEntity) {
            this.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new AnchorListUpdateSerializer.AnchorListUpdateMessage(TravelAnchorList.get(player.func_130014_f_()).func_189551_b(new CompoundNBT())));
        }
    }

    public void sendClientEventToServer(World world, ClientEventSerializer.ClientEvent event) {
        if (world.field_72995_K) {
            this.instance.sendToServer((Object)event);
        }
    }
}

