/*
 * Decompiled with CFR 0.152.
 */
package com.khanhpham.advancementplus.setup.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.khanhpham.advancementplus.setup.data.ToolType;
import com.khanhpham.advancementplus.setup.registry.Registration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.PlayerGeneratesContainerLootTrigger;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.structure.Structure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ModAdvancementProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = this.getPath(path, (Advancement)p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new ModAdvancement().accept(consumer);
    }

    @MethodsReturnNonnullByDefault
    public String func_200397_b() {
        return "Advancement Plus - Plus";
    }

    public Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/advancementplus/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    private static final class ModAdvancement
    implements Consumer<Consumer<Advancement>> {
        private static final List<RegistryKey<Biome>> EXPLORATION_BIOMES = ImmutableList.of((Object)Biomes.field_150582_Q, (Object)Biomes.field_76781_i, (Object)Biomes.field_76780_h, (Object)Biomes.field_76769_d, (Object)Biomes.field_76785_t, (Object)Biomes.field_150581_V, (Object)Biomes.field_150584_S, (Object)Biomes.field_150589_Z, (Object)Biomes.field_76767_f, (Object)Biomes.field_150576_N, (Object)Biomes.field_76774_n, (Object)Biomes.field_76784_u, (Object[])new RegistryKey[]{Biomes.field_76775_o, Biomes.field_150607_aa, Biomes.field_150588_X, Biomes.field_76772_c, Biomes.field_76777_m, Biomes.field_150578_U, Biomes.field_150577_O, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_76788_q, Biomes.field_76770_e, Biomes.field_76786_s, Biomes.field_76782_w, Biomes.field_76787_r, Biomes.field_150587_Y, Biomes.field_150579_T, Biomes.field_150608_ab, Biomes.field_150585_R, Biomes.field_76768_g, Biomes.field_150583_P, Biomes.field_76789_p, Biomes.field_150580_W, Biomes.field_203614_T, Biomes.field_203615_U, Biomes.field_203616_V, Biomes.field_203618_X, Biomes.field_203619_Y, Biomes.field_203620_Z, Biomes.field_222370_aw, Biomes.field_222371_ax});
        private String key;
        private final List<RegistryKey<Biome>> allTheBiomes = ImmutableList.of((Object)Biomes.field_76774_n, (Object)Biomes.field_185445_W, (Object)Biomes.field_150584_S, (Object)Biomes.field_185431_ac, (Object)Biomes.field_76777_m, (Object)Biomes.field_150577_O, (Object)Biomes.field_76770_e, (Object)Biomes.field_185443_S, (Object)Biomes.field_150580_W, (Object)Biomes.field_185434_af, (Object)Biomes.field_76768_g, (Object)Biomes.field_150590_f, (Object[])new RegistryKey[]{Biomes.field_150578_U, Biomes.field_185432_ad, Biomes.field_150576_N, Biomes.field_76772_c, Biomes.field_76767_f, Biomes.field_185441_Q, Biomes.field_185444_T, Biomes.field_150583_P, Biomes.field_185448_Z, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76780_h, Biomes.field_150599_m, Biomes.field_76782_w, Biomes.field_185446_X, Biomes.field_150574_L, Biomes.field_185447_Y, Biomes.field_222370_aw, Biomes.field_76781_i, Biomes.field_76787_r, Biomes.field_76789_p, Biomes.field_76788_q, Biomes.field_76769_d, Biomes.field_185442_R, Biomes.field_150588_X, Biomes.field_185435_ag, Biomes.field_185437_ai, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_185438_aj, Biomes.field_150608_ab, Biomes.field_150587_Y, Biomes.field_185439_ak, Biomes.field_185436_ah, Biomes.field_76771_b, Biomes.field_203615_U, Biomes.field_203618_X, Biomes.field_203614_T, Biomes.field_150575_M, Biomes.field_203616_V, Biomes.field_203619_Y, Biomes.field_76776_l, Biomes.field_203620_Z, Biomes.field_76775_o, Biomes.field_150581_V, Biomes.field_76786_s, Biomes.field_76792_x, Biomes.field_222371_ax, Biomes.field_150582_Q, Biomes.field_76785_t, Biomes.field_185433_ae, Biomes.field_76784_u, Biomes.field_150579_T, Biomes.field_185429_aa, Biomes.field_235254_j_, Biomes.field_235252_ay_, Biomes.field_235253_az_, Biomes.field_235250_aA_, Biomes.field_235251_aB_, Biomes.field_76779_k, Biomes.field_201939_S, Biomes.field_201936_P, Biomes.field_201937_Q, Biomes.field_201938_R, Biomes.field_185440_P});

        private ModAdvancement() {
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement root = ModAdvancement.makeBiomesAdvancement(this.getBuilder(), EXPLORATION_BIOMES).func_203902_a((IItemProvider)Registration.ICON.get(), (ITextComponent)new TranslationTextComponent("advancement.plus.root.title"), (ITextComponent)new TranslationTextComponent("advancement.plus.root.desc"), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.CHALLENGE, false, false, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getID());
            Advancement workbench = this.getBuilder().func_203905_a(root).func_203902_a((IItemProvider)Items.field_221734_cc, (ITextComponent)this.getTitle("workbench"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, false, false).func_200275_a("has_crafting_table", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221734_cc)).func_203904_a(consumer, this.getId("workbench"));
            Advancement hotTopic = this.getBuilder().func_203905_a(workbench).func_203902_a((IItemProvider)Items.field_221738_ce, (ITextComponent)this.getTitle("hot_topic"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_furnace", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221738_ce)).func_203904_a(consumer, this.getId("hot_topic"));
            Advancement shinyMetal = this.getBuilder().func_203905_a(hotTopic).func_203902_a((IItemProvider)Items.field_151043_k, (ITextComponent)this.getTitle("shiny_metal"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_gold_ingot", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151043_k)).func_203904_a(consumer, this.getId("shiny_metal"));
            Advancement powerCrystal = this.getBuilder().func_203905_a(shinyMetal).func_203902_a((IItemProvider)Items.field_196128_bn, (ITextComponent)this.getTitle("lapis"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_lapis", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_196128_bn)).func_203904_a(consumer, this.getId("power_crystal"));
            Advancement shockingPowder = this.getBuilder().func_203905_a(powerCrystal).func_203902_a((IItemProvider)Items.field_151137_ax, (ITextComponent)this.getTitle("shocking_powder"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_redstone", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151137_ax)).func_203904_a(consumer, this.getId("shocking_powder"));
            Advancement blueMoney = this.getBuilder().func_203905_a(shockingPowder).func_203902_a((IItemProvider)Items.field_151166_bC, (ITextComponent)this.getTitle("blue_money"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_emerald", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151166_bC)).func_203904_a(consumer, this.getId("blue_money"));
            Advancement isntThisDiamondPick = this.advancement(consumer, workbench, (IItemProvider)Items.field_151046_w, "isnt_this_diamond_pick", FrameType.TASK, "has_diamond_pickaxe", (IItemProvider)Items.field_151046_w, "diamond_pickaxe");
            Advancement pickaxeFromNether = this.advancement(consumer, isntThisDiamondPick, (IItemProvider)Items.field_234756_kK_, "pickaxe_from_nether", FrameType.GOAL, "has_netherite_pickaxe", (IItemProvider)Items.field_234756_kK_, "pickaxe_netherite");
            ImmutableList diamondArmor = ImmutableList.of((Object)Items.field_151163_ad, (Object)Items.field_151175_af, (Object)Items.field_151173_ae, (Object)Items.field_151161_ac);
            Advancement diamondMan = this.advancement(consumer, powerCrystal, (IItemProvider)Items.field_151163_ad, "diamond_man", FrameType.GOAL, "has_full_diamond", (List)diamondArmor, "full_diamond");
            Advancement iAmHungry = this.getBuilder().func_203905_a(hotTopic).func_203902_a((IItemProvider)Items.field_222101_pH, (ITextComponent)this.getTitle("i_am_hungry"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_smoker", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_222101_pH)).func_203904_a(consumer, this.getId("i_am_hungry"));
            Advancement iNeedIron = this.getBuilder().func_203905_a(iAmHungry).func_203902_a((IItemProvider)Items.field_222102_pI, (ITextComponent)this.getTitle("i_need_iron"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("has_blast_furnace", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_222102_pI)).func_203904_a(consumer, this.getId("i_need_iron"));
            Advancement allTheStones = this.getBuilder().func_203905_a(root).func_203902_a((IItemProvider)Items.field_221574_b, (ITextComponent)this.getTitle("all_the_stones"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("has_stone", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221574_b)).func_200275_a("has_andesite", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221579_g)).func_200275_a("has_andesite_1", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221580_h)).func_200275_a("has_granite", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221575_c)).func_200275_a("has_granite_1", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221576_d)).func_200275_a("has_diorite", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221577_e)).func_200275_a("has_diorite_1", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221578_f)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, this.getId("all_the_stones"));
            Advancement allTheLogs = this.getBuilder().func_203905_a(allTheStones).func_203902_a((IItemProvider)Items.field_221572_Y, (ITextComponent)this.getTitle("all_the_logs"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200275_a("has_oak", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221554_G)).func_200275_a("has_birch", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221556_I)).func_200275_a("has_spruce", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221555_H)).func_200275_a("has_acacia", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221558_K)).func_200275_a("has_jungle", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221557_J)).func_200275_a("has_dark_oak", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221559_L)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, this.getId("all_the_logs"));
            Advancement allTheSaplings = this.getBuilder().func_203905_a(allTheLogs).func_203902_a((IItemProvider)Items.field_221592_t, (ITextComponent)this.getTitle("all_the_saplings"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200275_a("has_oak", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221592_t)).func_200275_a("has_birch", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221594_v)).func_200275_a("has_spruce", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221593_u)).func_200275_a("has_acacia", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221596_x)).func_200275_a("has_jungle", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221595_w)).func_200275_a("has_dark_oak", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221597_y)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, this.getId("all_the_saplings"));
            Advancement allTheDiamondTools = this.getBuilder().func_203905_a(allTheSaplings).func_203902_a((IItemProvider)Items.field_151163_ad, (ITextComponent)this.getTitle("all_diamond_tools"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200275_a("has_pickaxe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151046_w)).func_200275_a("has_axe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151056_x)).func_200275_a("has_hoe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151012_L)).func_200275_a("has_sword", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151048_u)).func_200275_a("has_shovel", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151047_v)).func_200275_a("has_helmet", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151161_ac)).func_200275_a("has_chestplate", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151163_ad)).func_200275_a("has_leggings", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151173_ae)).func_200275_a("has_boots", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151175_af)).func_200275_a("has_horse_armor", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151125_bZ)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_203904_a(consumer, this.getId("all_diamond_tools"));
            Advancement allTheNetheriteTools = this.getBuilder().func_203905_a(allTheDiamondTools).func_203902_a((IItemProvider)Items.field_234764_lt_, (ITextComponent)this.getTitle("all_netherite_tools"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200275_a("has_pickaxe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234756_kK_)).func_200275_a("has_axe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234757_kL_)).func_200275_a("has_hoe", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234758_kU_)).func_200275_a("has_sword", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234754_kI_)).func_200275_a("has_shovel", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234755_kJ_)).func_200275_a("has_helmet", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234763_ls_)).func_200275_a("has_chestplate", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234764_lt_)).func_200275_a("has_leggings", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234765_lu_)).func_200275_a("has_boots", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_234766_lv_)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)1000)).func_203904_a(consumer, this.getId("all_netherite_tools"));
            Advancement seven_sea = ModAdvancement.makeBiomesAdvancement(this.getBuilder(), (List<RegistryKey<Biome>>)ImmutableList.of((Object)Biomes.field_76771_b, (Object)Biomes.field_203616_V, (Object)Biomes.field_203619_Y, (Object)Biomes.field_203620_Z, (Object)Biomes.field_203618_X, (Object)Biomes.field_150575_M, (Object)Biomes.field_203617_W, (Object)Biomes.field_203615_U, (Object)Biomes.field_203614_T)).func_203905_a(workbench).func_203902_a((IItemProvider)Items.field_151124_az, (ITextComponent)this.getTitle("seven_sea"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200270_a(IRequirementsStrategy.field_223214_a_).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_203904_a(consumer, this.getId("seven_sea"));
            Advancement underwaterGuardian = this.getBuilder().func_203905_a(seven_sea).func_203902_a((IItemProvider)Items.field_221879_fX, (ITextComponent)this.getTitle("underwater_guardian"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("found_monument", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236376_l_))).func_203904_a(consumer, this.setExploringId("underwater_guardian"));
            Advancement egyptPyramid = this.getBuilder().func_203905_a(underwaterGuardian).func_203902_a((IItemProvider)Items.field_221660_ar, (ITextComponent)this.getTitle("egypt_pyramid"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("found_pyramid", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236370_f_))).func_203904_a(consumer, this.setExploringId("egypt_pyramid"));
            Advancement runForYourLife = this.getBuilder().func_203905_a(egyptPyramid).func_203903_a(new DisplayInfo(new ItemStack((IItemProvider)Items.field_222114_py), (ITextComponent)this.getTitle("outpost"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false)).func_200275_a("found_outpost", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236366_b_))).func_203904_a(consumer, this.setExploringId("outpost"));
            Advancement whoIsRaider = this.makeLootAdvancement("loot_outpost", new ResourceLocation("chests/pillager_outpost")).func_203905_a(runForYourLife).func_203902_a((IItemProvider)Items.field_221675_bZ, (ITextComponent)this.getTitle("who_is_raider_now"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_203904_a(consumer, this.setLootingId("loot_outpost"));
            Advancement titanic = this.getBuilder().func_203905_a(runForYourLife).func_203902_a((IItemProvider)Items.field_221591_s, (ITextComponent)this.getTitle("titanic"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("to_shipwreck", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236373_i_))).func_203904_a(consumer, this.setExploringId("titanic"));
            Advancement isn_tThisMap = this.makeLootAdvancement("loot_shipwreck_map", new ResourceLocation("chests/shipwreck_map")).func_203902_a((IItemProvider)Items.field_151098_aY, (ITextComponent)this.getTitle("isnt_this_map"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_203905_a(titanic).func_203904_a(consumer, this.setLootingId("shipwreck_map"));
            Advancement imRich = this.makeLootAdvancement("loot_shipwreck_treasure", new ResourceLocation("chests/shipwreck_treasure")).func_203902_a((IItemProvider)Items.field_191525_da, (ITextComponent)this.getTitle("i_am_rich"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_203905_a(isn_tThisMap).func_203904_a(consumer, this.setLootingId("shipwreck_treasure"));
            Advancement iAmPirate = this.makeLootAdvancement("loot_treasure", new ResourceLocation("chests/buried_treasure")).func_203905_a(titanic).func_203902_a((IItemProvider)Items.field_221675_bZ, (ITextComponent)this.getTitle("i_am_pirate"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_203904_a(consumer, this.setLootingId("i_am_pirate"));
            Advancement deepDarkMine = this.getBuilder().func_203905_a(iAmPirate).func_203902_a((IItemProvider)Blocks.field_196662_n.func_199767_j(), (ITextComponent)this.getTitle("to_mineshaft"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("to_mineshaft", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236367_c_))).func_203904_a(consumer, this.setExploringId("deep_dark_mine"));
            Advancement lootMineshaft = this.getBuilder().func_203905_a(deepDarkMine).func_203902_a((IItemProvider)Items.field_151108_aI, (ITextComponent)this.getTitle("loot_mineshaft"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("loot_mineshaft", (ICriterionInstance)PlayerGeneratesContainerLootTrigger.Instance.func_235481_a_((ResourceLocation)new ResourceLocation("chests/abandoned_mineshaft"))).func_203904_a(consumer, this.setLootingId("loot_mineshaft"));
            Advancement mansionOfTheDark = this.getBuilder().func_203905_a(deepDarkMine).func_203902_a((IItemProvider)Items.field_221559_L, (ITextComponent)this.getTitle("found_woodland_mansion"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200275_a("to_mansion", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)Structure.field_236368_d_))).func_203904_a(consumer, this.setExploringId("to_mansion"));
            Advancement yesImTheRaider = this.makeLootAdvancement("loot_mansion", new ResourceLocation("chests/woodland_mansion")).func_203905_a(mansionOfTheDark).func_203902_a((IItemProvider)Items.field_221675_bZ, (ITextComponent)this.getTitle("yes_im_the_raider"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_203904_a(consumer, this.setLootingId("loot_mansion"));
            Advancement tombRaider = this.makeExploringAdvancement("to_jungle_temple", LocationPredicate.func_218020_a((Structure)Structure.field_236369_e_)).func_203905_a(mansionOfTheDark).func_203902_a((IItemProvider)Items.field_221653_bO, (ITextComponent)this.getTitle("tomb_raider"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_203904_a(consumer, this.setExploringId("jungle_temple"));
            Advancement tombRaided = this.getBuilder().func_203905_a(tombRaider).func_203902_a((IItemProvider)Items.field_221656_ap, (ITextComponent)this.getTitle("tomb_raided"), (ITextComponent)this.getDesc(), null, FrameType.TASK, true, true, false).func_200275_a("loot_chest", (ICriterionInstance)PlayerGeneratesContainerLootTrigger.Instance.func_235481_a_((ResourceLocation)new ResourceLocation("chests/jungle_temple"))).func_200275_a("loot_dispenser", (ICriterionInstance)PlayerGeneratesContainerLootTrigger.Instance.func_235481_a_((ResourceLocation)new ResourceLocation("chests/jungle_temple_dispenser"))).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.setLootingId("tomb_raided"));
            Advancement shinyApple = this.getBuilder().func_203905_a(shinyMetal).func_203902_a((IItemProvider)Items.field_151153_ao, (ITextComponent)this.getTitle("gold_apple"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("has_golden_apple", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_151153_ao)).func_203904_a(consumer, this.getId("shiny_apple"));
            Advancement not_Chap_ple = this.advancement(consumer, shinyApple, (IItemProvider)Items.field_196100_at, "notchaple", FrameType.CHALLENGE, "has_notchaple", (IItemProvider)Items.field_196100_at, "not_chap_ple");
            Advancement happy_new_year = this.advancement(consumer, root, (IItemProvider)Items.field_196152_dE, "happy_new_year", FrameType.TASK, "has_firework", (IItemProvider)Items.field_196152_dE, "happy_new_year");
            Advancement truly_happy_new_year = this.advancement(consumer, happy_new_year, (IItemProvider)Items.field_196153_dF, "truly_hny", FrameType.TASK, "has_star", (IItemProvider)Items.field_196153_dF, "truly_happy_new_year");
            Advancement where_the_freak_am_i = this.getBuilder().func_203905_a(allTheNetheriteTools).func_203902_a((IItemProvider)Items.field_221598_z, (ITextComponent)this.getTitle("where_the_freak_am_i"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("pass_the_void", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_242665_a((RegistryKey)Biomes.field_185440_P))).func_203904_a(consumer, this.getId("where_am_i"));
            Advancement all_the_biomes = ModAdvancement.makeBiomesAdvancement(this.getBuilder(), this.allTheBiomes).func_203905_a(where_the_freak_am_i).func_203902_a((IItemProvider)Items.field_234766_lv_, (ITextComponent)this.getTitle("all_the_biomes"), (ITextComponent)this.getDesc(), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10000)).func_203904_a(consumer, this.getId("all_the_biomes"));
            Advancement lightFromTheOcean = this.getBuilder().func_203905_a(not_Chap_ple).func_203902_a((IItemProvider)Items.field_221944_gd, (ITextComponent)this.getTitle("light_from_the_ocean"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("has_sea_lantern", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_221944_gd)).func_203904_a(consumer, this.getId("light_from_the_ocean"));
            Advancement sharpSpikes = this.getBuilder().func_203905_a(lightFromTheOcean).func_203902_a((IItemProvider)Items.field_203184_eO, (ITextComponent)this.getTitle("sharp_spikes"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200275_a("has_trident", (ICriterionInstance)this.getRequireItem((IItemProvider)Items.field_203184_eO)).func_203904_a(consumer, this.getId("trident"));
            Advancement silkyPickaxe = this.makeToolTierEnchantment(this.getBuilder(), (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.AXE), (Object)((Object)ToolType.PICKAXE), (Object)((Object)ToolType.SWORD), (Object)((Object)ToolType.SHOVEL), (Object)((Object)ToolType.HOE)), Enchantments.field_185306_r).func_203905_a(root).func_203902_a((IItemProvider)Items.field_151123_aH, (ITextComponent)this.getTitle("silky_pickaxe"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.setEnchantId("silky_pickaxe"));
            Advancement sharpnessSword = this.makeToolTierEnchantment(this.getBuilder(), (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.SWORD), (Object)((Object)ToolType.AXE)), Enchantments.field_185302_k).func_203905_a(silkyPickaxe).func_203902_a((IItemProvider)Items.field_151048_u, (ITextComponent)this.getTitle("sharpness_sword"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.setEnchantId("sharpness_sword"));
            Advancement luckyPickaxe = this.makeToolTierEnchantment(this.getBuilder(), (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.PICKAXE), (Object)((Object)ToolType.AXE)), Enchantments.field_185308_t).func_203905_a(silkyPickaxe).func_203902_a((IItemProvider)Items.field_196128_bn, (ITextComponent)this.getTitle("lucky_pickaxe"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, true).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.setEnchantId("lucky_pickaxe"));
            Advancement witheringSword = this.makeToolTierEnchantment(this.getBuilder(), (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.SWORD), (Object)((Object)ToolType.AXE)), Enchantments.field_185303_l).func_203902_a((IItemProvider)Items.field_196183_dw, (ITextComponent)this.getTitle("withering_sword"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203905_a(sharpnessSword).func_203904_a(consumer, this.setEnchantId("withering_sword"));
            Advancement hardToBreak = this.makeAllToolsAdvancement(Enchantments.field_185307_s, false).func_203905_a(luckyPickaxe).func_203902_a((IItemProvider)Items.field_221698_bk, (ITextComponent)this.getTitle("hard_to_breaking"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_203904_a(consumer, this.setEnchantId("hark_from_breaking"));
            Advancement mending = this.makeAllToolsAdvancement(Enchantments.field_185296_A, false).func_203905_a(hardToBreak).func_203902_a((IItemProvider)Registration.XP_ORB.get(), (ITextComponent)this.getTitle("mending_pickaxe"), (ITextComponent)this.getDesc(), null, FrameType.GOAL, true, true, false).func_203904_a(consumer, this.setEnchantId("mending_tool"));
        }

        private Advancement.Builder makeLootAdvancement(String criterion, ResourceLocation lootId) {
            Advancement.Builder builder = this.getBuilder();
            builder.func_200275_a(criterion, (ICriterionInstance)PlayerGeneratesContainerLootTrigger.Instance.func_235481_a_((ResourceLocation)lootId));
            return builder;
        }

        private Advancement.Builder makeExploringAdvancement(String criterion, LocationPredicate location) {
            Advancement.Builder builder = this.getBuilder();
            builder.func_200275_a(criterion, (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)location));
            return builder;
        }

        private Advancement.Builder makeAllToolsAdvancement(Enchantment enchant, boolean requireAll) {
            ImmutableList toolList = ImmutableList.of((Object)((Object)ToolType.AXE), (Object)((Object)ToolType.PICKAXE), (Object)((Object)ToolType.SWORD), (Object)((Object)ToolType.SHOVEL), (Object)((Object)ToolType.HOE));
            Advancement.Builder builder = this.getBuilder();
            int size = 1;
            if (enchant == Enchantments.field_185306_r || enchant == Enchantments.field_185296_A || enchant == Enchantments.field_203196_F) {
                for (ToolType tools : toolList) {
                    for (Item tool : tools.getTools()) {
                        builder.func_200275_a("enchant_" + size, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)tool).func_218003_a(new EnchantmentPredicate(enchant, MinMaxBounds.IntBound.func_211345_a((int)1))).func_200310_b()}));
                        ++size;
                    }
                }
            } else {
                for (ToolType tools : toolList) {
                    for (Item tool : tools.getTools()) {
                        builder.func_200275_a("enchant_" + size, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)tool).func_218003_a(new EnchantmentPredicate(enchant, MinMaxBounds.IntBound.func_211340_b((int)1))).func_200310_b()}));
                        ++size;
                    }
                }
                if (requireAll) {
                    builder.func_200270_a(IRequirementsStrategy.field_223214_a_);
                } else {
                    builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
                }
            }
            return builder;
        }

        private Advancement.Builder makeToolTierEnchantment(Advancement.Builder builder, List<ToolType> list, Enchantment enchant) {
            int size = 1;
            if (enchant == Enchantments.field_185306_r || enchant == Enchantments.field_185296_A || enchant == Enchantments.field_203196_F) {
                for (ToolType type : list) {
                    for (Item tool : type.getTools()) {
                        builder.func_200275_a("enchant_" + size, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)tool).func_218003_a(new EnchantmentPredicate(enchant, MinMaxBounds.IntBound.func_211345_a((int)1))).func_200310_b()}));
                        ++size;
                    }
                }
            } else {
                for (ToolType type : list) {
                    for (Item tool : type.getTools()) {
                        builder.func_200275_a("enchant_" + size, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)tool).func_218003_a(new EnchantmentPredicate(enchant, MinMaxBounds.IntBound.func_211340_b((int)1))).func_200310_b()}));
                        ++size;
                    }
                }
            }
            return builder;
        }

        private Advancement advancement(Consumer<Advancement> consumer, Advancement parent, IItemProvider icon, String translationKey, FrameType frame, String criterionName, IItemProvider requireItem, String id) {
            return this.getBuilder().func_203905_a(parent).func_203902_a(icon, (ITextComponent)this.getTitle(translationKey), (ITextComponent)this.getDesc(), null, frame, true, true, false).func_200275_a(criterionName, (ICriterionInstance)this.getRequireItem(requireItem)).func_203904_a(consumer, this.getId(id));
        }

        private <T extends IItemProvider> Advancement advancement(Consumer<Advancement> consumer, Advancement parent, IItemProvider icon, String translationKey, FrameType frame, String criterionName, List<T> requireItemList, String id) {
            return this.makeListItemsTrigger(this.getBuilder(), requireItemList).func_203905_a(parent).func_203902_a(icon, (ITextComponent)this.getTitle(translationKey), (ITextComponent)this.getDesc(), null, frame, true, true, false).func_203904_a(consumer, this.getId(id));
        }

        private String setExploringId(String key) {
            return "advancementplus:plus/exploring/" + key;
        }

        private String setLootingId(String key) {
            return "advancementplus:plus/loot/" + key;
        }

        private String setEnchantId(String id) {
            return "advancementplus:plus/enchantment/" + id;
        }

        private <T extends IItemProvider> Advancement.Builder makeListItemsTrigger(Advancement.Builder builder, List<T> itemList) {
            for (IItemProvider item : itemList) {
                builder.func_200275_a(item.toString(), (ICriterionInstance)this.getRequireItem(item));
            }
            return builder;
        }

        private InventoryChangeTrigger.Instance getRequireItem(IItemProvider item) {
            return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{item});
        }

        private static Advancement.Builder makeBiomesAdvancement(Advancement.Builder builder, List<RegistryKey<Biome>> biomes) {
            for (RegistryKey<Biome> registryKey : biomes) {
                builder.func_200275_a(registryKey.func_240901_a_().toString(), (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_242665_a(registryKey)));
            }
            return builder;
        }

        private String getId(String key) {
            String ID = "advancementplus";
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) != ' ') continue;
                throw new IllegalStateException("Id can not have space!");
            }
            return "advancementplus:plus/" + key;
        }

        private String getID() {
            String ID = "advancementplus";
            return "advancementplus:plus/root";
        }

        private TranslationTextComponent getTitle(String key) {
            this.key = key;
            for (int i = 0; i < key.length(); i = (int)((short)(i + 1))) {
                if (key.charAt(i) != ' ') continue;
                throw new IllegalStateException("Title key can not have space! HAIYA ~~");
            }
            return new TranslationTextComponent("advancement.plus." + key + ".title");
        }

        private TranslationTextComponent getDesc() {
            return new TranslationTextComponent("advancement.plus." + this.key + ".desc");
        }

        private Advancement.Builder getBuilder() {
            return Advancement.Builder.func_200278_a();
        }
    }
}

