/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking;

import architectury_inject_architectury_common_1d6c2e09cd5e4df481222b119aed0475.PlatformMethods;
import java.util.Objects;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class NetworkManager {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver receiver) {
        void var2_2;
        void var1_1;
        PlatformMethods.platform("registerReceiver", (Side)side, (ResourceLocation)var1_1, (NetworkReceiver)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IPacket<?> toPacket(Side side, ResourceLocation id, PacketBuffer buf) {
        void var2_2;
        void var1_1;
        return PlatformMethods.platform("toPacket", (Side)side, (ResourceLocation)var1_1, (PacketBuffer)var2_2);
    }

    public static void sendToPlayer(ServerPlayerEntity player, ResourceLocation id, PacketBuffer buf) {
        Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf));
    }

    public static void sendToPlayers(Iterable<ServerPlayerEntity> players, ResourceLocation id, PacketBuffer buf) {
        IPacket<?> packet = NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf);
        for (ServerPlayerEntity player : players) {
            Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, PacketBuffer buf) {
        if (Minecraft.func_71410_x().func_147114_u() == null) {
            throw new IllegalStateException("Unable to send packet to the server while not in game!");
        }
        Minecraft.func_71410_x().func_147114_u().func_147297_a(NetworkManager.toPacket(NetworkManager.clientToServer(), id, buf));
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(ResourceLocation id) {
        return (boolean)PlatformMethods.platform("canServerReceive", (ResourceLocation)id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(ServerPlayerEntity player, ResourceLocation id) {
        void var1_1;
        return (boolean)PlatformMethods.platform("canPlayerReceive", (ServerPlayerEntity)player, (ResourceLocation)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IPacket<?> createAddEntityPacket(Entity entity) {
        return PlatformMethods.platform("createAddEntityPacket", (Entity)entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    public static interface PacketContext {
        public PlayerEntity getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(PacketBuffer var1, PacketContext var2);
    }
}

