/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.ServerProxy;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.client.gui.GuiCitadelBook;
import com.github.alexthe666.citadel.client.gui.GuiCitadelPatreonConfig;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.github.alexthe666.citadel.client.patreon.SpaceStationPatreonRenderer;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.entity.datatracker.EntityDataHandler;
import com.github.alexthe666.citadel.server.entity.datatracker.EntityProperties;
import com.github.alexthe666.citadel.server.entity.datatracker.IEntityData;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.CustomizeSkinScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends ServerProxy {
    public static TabulaModel CITADEL_MODEL;
    private static final ResourceLocation CITADEL_TEXTURE;
    private static final ResourceLocation CITADEL_TEXTURE_RED;
    private static final ResourceLocation CITADEL_TEXTURE_GRAY;

    @Override
    public void onPreInit() {
        try {
            CITADEL_MODEL = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/citadel/models/citadel_model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CitadelPatreonRenderer.register("citadel", new SpaceStationPatreonRenderer(CITADEL_TEXTURE));
        CitadelPatreonRenderer.register("citadel_red", new SpaceStationPatreonRenderer(CITADEL_TEXTURE_RED));
        CitadelPatreonRenderer.register("citadel_gray", new SpaceStationPatreonRenderer(CITADEL_TEXTURE_GRAY));
    }

    @SubscribeEvent
    public void openCustomizeSkinScreen(GuiScreenEvent.InitGuiEvent event) {
        String username;
        if (event.getGui() instanceof CustomizeSkinScreen && Citadel.PATREONS.contains(username = Minecraft.func_71410_x().field_71439_g.func_200200_C_().func_150261_e())) {
            event.addWidget((Widget)new Button(event.getGui().field_230708_k_ / 2 - 100, event.getGui().field_230709_l_ / 6 + 150, 200, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.patreon_rewards_option").func_240699_a_(TextFormatting.GREEN), p_213080_2_ -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiCitadelPatreonConfig(event.getGui(), Minecraft.func_71410_x().field_71474_y))));
        }
    }

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Post event) {
        MatrixStack matrixStackIn = event.getMatrixStack();
        String username = event.getPlayer().func_200200_C_().func_150261_e();
        if (!event.getPlayer().func_175148_a(PlayerModelPart.CAPE)) {
            return;
        }
        if (Citadel.PATREONS.contains(username)) {
            CitadelPatreonRenderer renderer;
            String rendererName;
            CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
            String string = rendererName = tag.func_74764_b("CitadelFollowerType") ? tag.func_74779_i("CitadelFollowerType") : "citadel";
            if (!rendererName.equals("none") && (renderer = CitadelPatreonRenderer.get(rendererName)) != null) {
                float distance = tag.func_74764_b("CitadelRotateDistance") ? tag.func_74760_g("CitadelRotateDistance") : 2.0f;
                float speed = tag.func_74764_b("CitadelRotateSpeed") ? tag.func_74760_g("CitadelRotateSpeed") : 1.0f;
                float height = tag.func_74764_b("CitadelRotateHeight") ? tag.func_74760_g("CitadelRotateHeight") : 1.0f;
                renderer.render(matrixStackIn, event.getBuffers(), event.getLight(), event.getPartialRenderTick(), event.getEntityLiving(), distance, speed, height);
            }
        }
    }

    @Override
    public void handleAnimationPacket(int entityId, int index) {
        IAnimatedEntity entity;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (entity = (IAnimatedEntity)player.field_70170_p.func_73045_a(entityId)) != null) {
            if (index == -1) {
                entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
            } else {
                entity.setAnimation(entity.getAnimations()[index]);
            }
            entity.setAnimationTick(0);
        }
    }

    @Override
    public void handlePropertiesPacket(String propertyID, CompoundNBT compound, int entityID) {
        IEntityData<Entity> extendedProperties;
        if (compound == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity entity = player.field_70170_p.func_73045_a(entityID);
        if (propertyID.equals("CitadelPatreonConfig") && entity instanceof LivingEntity) {
            CitadelEntityData.setCitadelTag((LivingEntity)entity, compound);
        } else if (entity != null && (extendedProperties = EntityDataHandler.INSTANCE.getEntityData(entity, propertyID)) instanceof EntityProperties) {
            EntityProperties properties = (EntityProperties)extendedProperties;
            properties.loadTrackingSensitiveData(compound);
            properties.onSync();
        }
    }

    @Override
    public void openBookGUI(ItemStack book) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiCitadelBook(book));
    }

    static {
        CITADEL_TEXTURE = new ResourceLocation("citadel", "textures/patreon/citadel_model.png");
        CITADEL_TEXTURE_RED = new ResourceLocation("citadel", "textures/patreon/citadel_model_red.png");
        CITADEL_TEXTURE_GRAY = new ResourceLocation("citadel", "textures/patreon/citadel_model_gray.png");
    }
}

