/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.blocks;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.container.AdvancedCrafterContainer;
import edivad.extrastorage.nodes.AdvancedCrafterNetworkNode;
import edivad.extrastorage.tiles.AdvancedCrafterTile;
import edivad.extrastorage.tools.Translations;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class AdvancedCrafterBlock
extends NetworkNodeBlock {
    private final CrafterTier tier;

    public AdvancedCrafterBlock(CrafterTier tier) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.tier = tier;
    }

    public BlockDirection getDirection() {
        return BlockDirection.ANY_FACE_PLAYER;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AdvancedCrafterTile(this.tier);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof AdvancedCrafterTile && stack.func_82837_s()) {
            ((AdvancedCrafterNetworkNode)((AdvancedCrafterTile)tile).getNode()).setDisplayName(stack.func_200301_q());
            ((AdvancedCrafterNetworkNode)((AdvancedCrafterTile)tile).getNode()).markDirty();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            return NetworkUtils.attempt((World)worldIn, (BlockPos)pos, (PlayerEntity)player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new PositionalTileContainerProvider(((AdvancedCrafterNetworkNode)((AdvancedCrafterTile)worldIn.func_175625_s(pos)).getNode()).getName(), (tile, windowId, inventory, p) -> new AdvancedCrafterContainer(windowId, player, (AdvancedCrafterTile)((Object)((Object)tile))), pos), (BlockPos)pos), (Permission[])new Permission[]{Permission.MODIFY, Permission.AUTOCRAFTING});
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasConnectedState() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(Translations.SLOT_CRAFTING, new Object[]{this.tier.getSlots()}).func_240699_a_(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new TranslationTextComponent(Translations.BASE_SPEED, new Object[]{this.tier.getCraftingSpeed()}).func_240699_a_(TextFormatting.GREEN));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(Translations.HOLD_SHIFT).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

