/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.antibuild;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.antibuild.AntiBuildConfig;
import com.earth2me.essentials.antibuild.EssentialsAntiBuild;
import com.earth2me.essentials.antibuild.IAntiBuild;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EssentialsAntiBuildListener
implements Listener {
    private static final Logger logger = Logger.getLogger("EssentialsAntiBuild");
    private final transient IAntiBuild prot;
    private final transient IEssentials ess;

    EssentialsAntiBuildListener(IAntiBuild parent) {
        this.prot = parent;
        this.ess = this.prot.getEssentialsConnect().getEssentials();
        if (EssentialsAntiBuildListener.isEntityPickupEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new EntityPickupItemListener(), (Plugin)this.prot);
        } else {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PlayerPickupItemListener(), (Plugin)this.prot);
        }
    }

    private static boolean isEntityPickupEvent() {
        try {
            Class.forName("org.bukkit.event.entity.EntityPickupItemEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean metaPermCheck(User user, String action, Block block) {
        if (block == null) {
            if (this.ess.getSettings().isDebug()) {
                logger.log(Level.INFO, "AntiBuild permission check failed, invalid block.");
            }
            return false;
        }
        return this.metaPermCheck(user, action, block.getType(), block.getData());
    }

    public boolean metaPermCheck(User user, String action, Material material) {
        String blockPerm = "essentials.build." + action + "." + material;
        return user.isAuthorized(blockPerm);
    }

    private boolean metaPermCheck(User user, String action, Material material, short data) {
        String blockPerm = "essentials.build." + action + "." + material;
        String dataPerm = blockPerm + ":" + data;
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
            if (user.getBase().isPermissionSet(dataPerm)) {
                return user.isAuthorized(dataPerm);
            }
            if (this.ess.getSettings().isDebug()) {
                logger.log(Level.INFO, "DataValue perm on " + user.getName() + " is not directly set: " + dataPerm);
            }
        }
        return user.isAuthorized(blockPerm);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        Block block = event.getBlockPlaced();
        Material type = block.getType();
        if (type.equals((Object)event.getBlockReplacedState().getType())) {
            return;
        }
        if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild() && !this.metaPermCheck(user, "place", block)) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{EssentialsAntiBuild.getNameForType(type)}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_placement, type) && !user.isAuthorized("essentials.protect.exemptplacement")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{EssentialsAntiBuild.getNameForType(type)}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.alert_on_placement, type) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, EssentialsAntiBuild.getNameForType(type), I18n.tl((String)"alertPlaced", (Object[])new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        Block block = event.getBlock();
        Material type = block.getType();
        if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild() && !this.metaPermCheck(user, "break", block)) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{EssentialsAntiBuild.getNameForType(type)}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_break, type) && !user.isAuthorized("essentials.protect.exemptbreak")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{EssentialsAntiBuild.getNameForType(type)}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.alert_on_break, type) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, EssentialsAntiBuild.getNameForType(type), I18n.tl((String)"alertBroke", (Object[])new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Entity entity = event.getRemover();
        if (entity instanceof Player) {
            User user = this.ess.getUser((Player)entity);
            EntityType type = event.getEntity().getType();
            boolean warn = this.ess.getSettings().warnOnBuildDisallow();
            if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild()) {
                if (type == EntityType.PAINTING && !this.metaPermCheck(user, "break", Material.PAINTING)) {
                    if (warn) {
                        user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{Material.PAINTING.toString()}));
                    }
                    event.setCancelled(true);
                } else if (type == EntityType.ITEM_FRAME && !this.metaPermCheck(user, "break", Material.ITEM_FRAME)) {
                    if (warn) {
                        user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{Material.ITEM_FRAME.toString()}));
                    }
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemFrameInteract(PlayerInteractEntityEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (!(event.getRightClicked() instanceof ItemFrame)) {
            return;
        }
        if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild() && !user.isAuthorized("essentials.build") && !this.metaPermCheck(user, "place", Material.ITEM_FRAME)) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{Material.ITEM_FRAME.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_placement, Material.ITEM_FRAME) && !user.isAuthorized("essentials.protect.exemptplacement")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{Material.ITEM_FRAME.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.alert_on_placement, Material.ITEM_FRAME) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, Material.ITEM_FRAME.toString(), I18n.tl((String)"alertPlaced", (Object[])new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (!(event.getRightClicked() instanceof ArmorStand)) {
            return;
        }
        if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild() && !user.isAuthorized("essentials.build") && !this.metaPermCheck(user, "place", Material.ARMOR_STAND)) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{Material.ARMOR_STAND.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_placement, Material.ARMOR_STAND) && !user.isAuthorized("essentials.protect.exemptplacement")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildPlace", (Object[])new Object[]{Material.ARMOR_STAND.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.alert_on_placement, Material.ARMOR_STAND) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, Material.ARMOR_STAND.toString(), I18n.tl((String)"alertPlaced", (Object[])new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockEntityDamage(EntityDamageByEntityEvent event) {
        Player player = null;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
            player = (Player)((Projectile)event.getDamager()).getShooter();
        } else {
            return;
        }
        User user = this.ess.getUser(player);
        Material type = null;
        if (event.getEntity() instanceof ItemFrame) {
            type = Material.ITEM_FRAME;
        } else if (event.getEntity() instanceof ArmorStand) {
            type = Material.ARMOR_STAND;
        } else if (event.getEntity() instanceof EnderCrystal) {
            type = Material.END_CRYSTAL;
        } else {
            return;
        }
        if (this.prot.getSettingBool(AntiBuildConfig.disable_build) && !user.canBuild() && !user.isAuthorized("essentials.build") && !this.metaPermCheck(user, "break", type)) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{type.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_break, type) && !user.isAuthorized("essentials.protect.exemptbreak")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildBreak", (Object[])new Object[]{type.toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (this.prot.checkProtectionItems(AntiBuildConfig.alert_on_break, type) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, type.toString(), I18n.tl((String)"alertBroke", (Object[])new Object[0]));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.prot.checkProtectionItems(AntiBuildConfig.blacklist_piston, block.getType())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        for (Block block : event.getBlocks()) {
            if (!this.prot.checkProtectionItems(AntiBuildConfig.blacklist_piston, block.getType())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteract(PlayerInteractEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        ItemStack item = event.getItem();
        if (item != null && this.prot.checkProtectionItems(AntiBuildConfig.blacklist_usage, item.getType()) && !user.isAuthorized("essentials.protect.exemptusage")) {
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildUse", (Object[])new Object[]{item.getType().toString()}));
            }
            event.setCancelled(true);
            return;
        }
        if (item != null && this.prot.checkProtectionItems(AntiBuildConfig.alert_on_use, item.getType()) && !user.isAuthorized("essentials.protect.alerts.notrigger")) {
            this.prot.getEssentialsConnect().alert(user, item.getType().toString(), I18n.tl((String)"alertUsed", (Object[])new Object[0]));
        }
        if (this.prot.getSettingBool(AntiBuildConfig.disable_use) && !user.canBuild()) {
            if (event.hasItem() && !this.metaPermCheck(user, "interact", item.getType(), item.getDurability())) {
                event.setCancelled(true);
                if (this.ess.getSettings().warnOnBuildDisallow()) {
                    user.sendMessage(I18n.tl((String)"antiBuildUse", (Object[])new Object[]{item.getType().toString()}));
                }
                return;
            }
            if (event.hasBlock() && !this.metaPermCheck(user, "interact", event.getClickedBlock())) {
                event.setCancelled(true);
                if (this.ess.getSettings().warnOnBuildDisallow()) {
                    user.sendMessage(I18n.tl((String)"antiBuildInteract", (Object[])new Object[]{event.getClickedBlock().getType().toString()}));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCraftItemEvent(CraftItemEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (entity instanceof Player) {
            User user = this.ess.getUser((Player)entity);
            ItemStack item = event.getRecipe().getResult();
            if (this.prot.getSettingBool(AntiBuildConfig.disable_use) && !user.canBuild() && !this.metaPermCheck(user, "craft", item.getType(), item.getDurability())) {
                event.setCancelled(true);
                if (this.ess.getSettings().warnOnBuildDisallow()) {
                    user.sendMessage(I18n.tl((String)"antiBuildCraft", (Object[])new Object[]{item.getType().toString()}));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        ItemStack item = event.getItemDrop().getItemStack();
        if (this.prot.getSettingBool(AntiBuildConfig.disable_use) && !user.canBuild() && !this.metaPermCheck(user, "drop", item.getType(), item.getDurability())) {
            event.setCancelled(true);
            user.getBase().updateInventory();
            if (this.ess.getSettings().warnOnBuildDisallow()) {
                user.sendMessage(I18n.tl((String)"antiBuildDrop", (Object[])new Object[]{item.getType().toString()}));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        ItemStack item = event.getItem();
        if (this.prot.checkProtectionItems(AntiBuildConfig.blacklist_dispenser, item.getType())) {
            event.setCancelled(true);
        }
    }

    private class PlayerPickupItemListener
    implements Listener {
        private PlayerPickupItemListener() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(PlayerPickupItemEvent event) {
            User user = EssentialsAntiBuildListener.this.ess.getUser(event.getPlayer());
            ItemStack item = event.getItem().getItemStack();
            if (EssentialsAntiBuildListener.this.prot.getSettingBool(AntiBuildConfig.disable_use) && !user.canBuild() && !EssentialsAntiBuildListener.this.metaPermCheck(user, "pickup", item.getType(), item.getDurability())) {
                event.setCancelled(true);
                event.getItem().setPickupDelay(50);
            }
        }
    }

    private class EntityPickupItemListener
    implements Listener {
        private EntityPickupItemListener() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(EntityPickupItemEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            User user = EssentialsAntiBuildListener.this.ess.getUser((Player)event.getEntity());
            ItemStack item = event.getItem().getItemStack();
            if (EssentialsAntiBuildListener.this.prot.getSettingBool(AntiBuildConfig.disable_use) && !user.canBuild() && !EssentialsAntiBuildListener.this.metaPermCheck(user, "pickup", item.getType(), item.getDurability())) {
                event.setCancelled(true);
                event.getItem().setPickupDelay(50);
            }
        }
    }
}

