/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.antibuild;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.User;
import com.earth2me.essentials.antibuild.AntiBuildConfig;
import com.earth2me.essentials.antibuild.IAntiBuild;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class EssentialsConnect {
    private static final Logger logger = Logger.getLogger("EssentialsAntiBuild");
    private final transient IEssentials ess;
    private final transient IAntiBuild protect;

    EssentialsConnect(Plugin essPlugin, Plugin essProtect) {
        if (!essProtect.getDescription().getVersion().equals(essPlugin.getDescription().getVersion())) {
            logger.log(Level.WARNING, I18n.tl((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        this.ess = (IEssentials)essPlugin;
        this.protect = (IAntiBuild)essProtect;
        AntiBuildReloader pr = new AntiBuildReloader();
        pr.reloadConfig();
        this.ess.addReloadListener((IConf)pr);
    }

    IEssentials getEssentials() {
        return this.ess;
    }

    void alert(User user, String item, String type) {
        Location loc = user.getLocation();
        String warnMessage = I18n.tl((String)"alertFormat", (Object[])new Object[]{user.getName(), type, item, loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ()});
        logger.log(Level.WARNING, warnMessage);
        for (Player p : this.ess.getServer().getOnlinePlayers()) {
            User alertUser = this.ess.getUser(p);
            if (!alertUser.isAuthorized("essentials.protect.alerts")) continue;
            alertUser.sendMessage(warnMessage);
        }
    }

    private class AntiBuildReloader
    implements IConf {
        private AntiBuildReloader() {
        }

        public void reloadConfig() {
            for (AntiBuildConfig protectConfig : AntiBuildConfig.values()) {
                if (protectConfig.isList()) {
                    EssentialsConnect.this.protect.getSettingsList().put(protectConfig, EssentialsConnect.this.ess.getSettings().getProtectList(protectConfig.getConfigName()));
                    continue;
                }
                EssentialsConnect.this.protect.getSettingsBoolean().put(protectConfig, EssentialsConnect.this.ess.getSettings().getProtectBoolean(protectConfig.getConfigName(), protectConfig.getDefaultValueBoolean()));
            }
        }
    }
}

