/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.tips.Tips;
import net.darkhax.tips.data.tip.ITip;
import net.darkhax.tips.data.tip.ITipSerializer;
import net.darkhax.tips.data.tip.SimpleTip;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class TipsAPI {
    public static final ITextComponent DEFAULT_TITLE = new TranslationTextComponent("tips.title.tip").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.UNDERLINE, TextFormatting.YELLOW});
    public static final SimpleTip NO_TIPS = new SimpleTip(new ResourceLocation("tips", "empty"), DEFAULT_TITLE, (ITextComponent)new TranslationTextComponent("tips.tip.no_tips").func_240699_a_(TextFormatting.RED));
    private final Map<ResourceLocation, ITipSerializer<?>> tipSerializers = new HashMap();
    private Map<ResourceLocation, ITip> tips = new HashMap<ResourceLocation, ITip>();

    public void registerTipSerializer(ResourceLocation id, ITipSerializer<?> serializer) {
        this.tipSerializers.put(id, serializer);
    }

    @Nullable
    public ITipSerializer<?> getTipSerializer(ResourceLocation id) {
        return this.tipSerializers.get(id);
    }

    @Nullable
    public ITip getTip(ResourceLocation id) {
        return this.tips.get(id);
    }

    @Nullable
    public ITip getRandomTip() {
        Collection tipPool = this.tips.entrySet().stream().filter(e -> Tips.CFG.canLoadTip((ResourceLocation)e.getKey())).map(e -> (ITip)e.getValue()).collect(Collectors.toList());
        return tipPool.isEmpty() ? NO_TIPS : (ITip)tipPool.stream().skip((int)((double)tipPool.size() * Math.random())).findFirst().orElse(null);
    }

    public void updateTips(Map<ResourceLocation, ITip> tips) {
        this.tips = ImmutableMap.copyOf(tips);
    }

    public Map<ResourceLocation, ITip> getTips() {
        return this.tips;
    }
}

