/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips.data.tip;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.serialization.Serializers;
import net.darkhax.tips.Tips;
import net.darkhax.tips.data.tip.ITip;
import net.darkhax.tips.data.tip.ITipSerializer;
import net.darkhax.tips.data.tip.SimpleTip;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;

public class TipReloadListener
extends ReloadListener<Map<ResourceLocation, ITip>> {
    protected void apply(Map<ResourceLocation, ITip> data, IResourceManager resources, IProfiler profiler) {
        Tips.LOG.info("Read {} tips.", (Object)data.size());
        Tips.API.updateTips(data);
    }

    protected Map<ResourceLocation, ITip> prepare(IResourceManager resources, IProfiler profiler) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap map = Maps.newHashMap();
        for (ResourceLocation candidate : resources.func_199003_a("tips", n -> n.endsWith(".json"))) {
            String path = candidate.func_110623_a();
            ResourceLocation entryId = new ResourceLocation(candidate.func_110624_b(), path.substring("tips/".length(), path.length() - ".json".length()));
            try {
                for (IResource resource : resources.func_199004_b(candidate)) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            Tips.LOG.debug("Skipping tip {} from {} as one or more of it's conditions were not met.", (Object)entryId, (Object)candidate);
                            continue;
                        }
                        ResourceLocation tipType = (ResourceLocation)Serializers.RESOURCE_LOCATION.read(json, "type", (Object)SimpleTip.TYPE_ID);
                        ITipSerializer<?> serializer = Tips.API.getTipSerializer(tipType);
                        if (serializer != null) {
                            Object tip = serializer.read(entryId, json);
                            if (tip != null) {
                                map.put(entryId, tip);
                                continue;
                            }
                            Tips.LOG.debug("Skipping tip {} from {}. Serializer {} returned null.", (Object)entryId, (Object)candidate, (Object)tipType);
                            continue;
                        }
                        Tips.LOG.error("Could not read tip {} from {}. Serializer {} does not exist!", (Object)entryId, (Object)candidate, (Object)tipType);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
            }
            catch (Exception e) {
                Tips.LOG.error("Unable to read tip of {} from {}.", (Object)entryId, (Object)candidate, (Object)e);
            }
        }
        return map;
    }
}

