/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Locale;
import net.darkhax.tips.Tips;
import net.darkhax.tips.data.tip.ITip;
import net.darkhax.tips.gui.ListEntry;
import net.darkhax.tips.gui.ListEntryTip;
import net.darkhax.tips.gui.TipsListScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TipsList
extends AbstractOptionList<ListEntry> {
    public TipsList(TipsListScreen parent, Minecraft mc) {
        super(mc, parent.field_230708_k_, parent.field_230709_l_, 43, parent.field_230709_l_ - 32, 50);
        this.refreshEntries(false, "");
    }

    public void refreshEntries(boolean showDisabled, String searchInput) {
        searchInput = searchInput.toLowerCase(Locale.ROOT);
        this.func_230963_j_();
        this.func_230932_a_(0.0);
        for (ITip tip : Tips.API.getTips().values()) {
            if (!showDisabled && !Tips.CFG.canLoadTip(tip.getId()) || !this.matchSearch(tip, searchInput)) continue;
            this.func_230513_b_((AbstractList.AbstractListEntry)new ListEntryTip(this.field_230668_b_, tip));
        }
    }

    private boolean matchSearch(ITip tip, String search) {
        if (search.isEmpty() || search == null) {
            return true;
        }
        if (tip.getId().toString().contains(search)) {
            return true;
        }
        if (TextFormatting.func_110646_a((String)tip.getTitle().getString()).toLowerCase(Locale.ROOT).contains(search)) {
            return true;
        }
        return TextFormatting.func_110646_a((String)tip.getText().getString()).toLowerCase(Locale.ROOT).contains(search);
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 20;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 32;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            for (int i = 0; i < this.func_230965_k_(); ++i) {
                ListEntry entry = (ListEntry)this.func_230953_d_(i);
                entry.isSelected = entry.func_231047_b_(mouseX, mouseY);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void func_230447_a_(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            for (int i = 0; i < this.func_230965_k_(); ++i) {
                ListEntry entry = (ListEntry)this.func_230953_d_(i);
                if (!entry.func_231047_b_(mouseX, mouseY)) continue;
                entry.renderMouseOver(matrix, mouseX, mouseY);
            }
        }
    }
}

