/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.config;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.badmobs.BadMobs;
import net.darkhax.badmobs.config.SpawnConfig;
import net.darkhax.badmobs.tempshelf.ConfigManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Configuration {
    private final ConfigManager manager;
    private final Map<EntityType<?>, SpawnConfig> configs = new HashMap();

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (EntityType type : ForgeRegistries.ENTITIES) {
            this.configs.put(type, new SpawnConfig(type.getRegistryName(), builder));
        }
        this.manager = new ConfigManager(builder.build());
        this.manager.registerWithForge();
        this.manager.open();
    }

    public boolean allowSpawn(Entity entity, SpawnReason reason, boolean world) {
        SpawnConfig config = this.configs.get(entity.func_200600_R());
        if (config == null) {
            if (!ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)entity.func_200600_R())) {
                BadMobs.LOG.error("The entity type {} of {} spawned but has not been registered. This is not allowed. SpawnReason={}", (Object)entity.func_200600_R().getRegistryName(), (Object)entity, (Object)reason);
            }
            return true;
        }
        return config.canSpawn(entity, reason, world);
    }
}

