/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.block;

import com.mrcrayfish.goldenhopper.tileentity.GoldenHopperTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class GoldenHopperBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape field_196326_A = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IHopper.field_200101_a, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)field_196326_A, (VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IHopper.field_200101_a;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public GoldenHopperBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)ENABLED, (Comparable)Boolean.TRUE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return field_196326_A;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IHopper.field_200101_a;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(direction.func_176740_k() == Direction.Axis.Y ? Direction.DOWN : direction))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GoldenHopperTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = worldIn.func_175625_s(pos)) instanceof GoldenHopperTileEntity) {
            ((GoldenHopperTileEntity)tileEntity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof GoldenHopperTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)((INamedContainerProvider)tileEntity));
            playerEntity.func_195066_a(Stats.field_188084_R);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)ENABLED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof GoldenHopperTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((GoldenHopperTileEntity)tileEntity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ENABLED});
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof GoldenHopperTileEntity) {
            ((GoldenHopperTileEntity)tileEntity).onEntityCollision(entityIn);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

