/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.entity;

import com.mrcrayfish.goldenhopper.init.ModBlocks;
import com.mrcrayfish.goldenhopper.init.ModEntities;
import com.mrcrayfish.goldenhopper.init.ModItems;
import com.mrcrayfish.goldenhopper.inventory.container.GoldenHopperContainer;
import com.mrcrayfish.goldenhopper.tileentity.GoldenHopperTileEntity;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.IHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class GoldenHopperMinecart
extends ContainerMinecartEntity
implements IHopper,
ISidedInventory {
    private boolean blocked = true;
    private int transferTicker = -1;
    private final BlockPos lastPosition = BlockPos.field_177992_a;

    public GoldenHopperMinecart(World world) {
        super((EntityType)ModEntities.GOLDEN_HOPPER_MINECART.get(), world);
    }

    public GoldenHopperMinecart(World world, double x, double y, double z) {
        super((EntityType)ModEntities.GOLDEN_HOPPER_MINECART.get(), x, y, z, world);
    }

    public GoldenHopperMinecart(EntityType<?> type, World world) {
        super(type, world);
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public int getTransferTicker() {
        return this.transferTicker;
    }

    public void setTransferTicker(int transferTicker) {
        this.transferTicker = transferTicker;
    }

    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    public boolean canTransfer() {
        return this.transferTicker > 0;
    }

    protected Container func_213968_a(int windowId, PlayerInventory playerInventory) {
        return new GoldenHopperContainer(windowId, playerInventory, (IInventory)this);
    }

    public BlockState func_180457_u() {
        return ((Block)ModBlocks.GOLDEN_HOPPER.get()).func_176223_P();
    }

    public int func_94085_r() {
        return 1;
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)ModItems.GOLDEN_HOPPER_MINECART.get());
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.HOPPER;
    }

    @Nullable
    public World func_145831_w() {
        return this.field_70170_p;
    }

    public double func_96107_aA() {
        return this.func_226277_ct_();
    }

    public double func_96109_aB() {
        return this.func_226278_cu_() + 0.5;
    }

    public double func_96108_aC() {
        return this.func_226281_cx_();
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 0 && (this.func_70301_a(0).func_190926_b() || stack.func_77973_b() == this.func_70301_a(0).func_77973_b());
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(1, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index != 0 && (this.func_70301_a(0).func_190926_b() || stack.func_77973_b() == this.func_70301_a(0).func_77973_b());
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (receivingPower == this.isBlocked()) {
            this.setBlocked(!receivingPower);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.isBlocked()) {
            BlockPos pos = this.func_233580_cy_();
            if (pos.equals((Object)this.lastPosition)) {
                --this.transferTicker;
            } else {
                this.setTransferTicker(0);
            }
            if (!this.canTransfer()) {
                this.setTransferTicker(0);
                if (this.captureDroppedItems()) {
                    this.setTransferTicker(4);
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean captureDroppedItems() {
        if (GoldenHopperTileEntity.pullItems(this)) {
            return true;
        }
        List list = this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(0.25, 0.0, 0.25), EntityPredicates.field_94557_a);
        if (!list.isEmpty()) {
            GoldenHopperTileEntity.captureItemEntity((IInventory)this, (ItemEntity)list.get(0));
        }
        return false;
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("TransferCooldown", this.transferTicker);
        compound.func_74757_a("Enabled", this.blocked);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.transferTicker = compound.func_74762_e("TransferCooldown");
        this.blocked = !compound.func_74764_b("Enabled") || compound.func_74767_n("Enabled");
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_199703_a((IItemProvider)ModBlocks.GOLDEN_HOPPER.get());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

