/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import bl4ckscor3.mod.xptome.Configuration;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import openmods.utils.EnchantmentUtils;

public class XPTomeItem
extends Item {
    public static final Style TOOLTIP_STYLE = Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_1 = new TranslationTextComponent("xpbook.tooltip.1").func_230530_a_(TOOLTIP_STYLE);
    private static final ITextComponent TOOLTIP_2 = new TranslationTextComponent("xpbook.tooltip.2").func_230530_a_(TOOLTIP_STYLE);

    public XPTomeItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int storedXP = this.getStoredXP(stack);
        if (player.func_225608_bj_() && storedXP < (Integer)Configuration.CONFIG.maxXP.get()) {
            int xpToStore = 0;
            if (((Boolean)Configuration.CONFIG.storeUntilPreviousLevel.get()).booleanValue()) {
                int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
                xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                if (xpToStore == 0 && player.field_71068_ca > 0) {
                    xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.field_71068_ca - 1);
                }
            } else {
                xpToStore = EnchantmentUtils.getPlayerXP(player);
            }
            if (xpToStore == 0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, xpToStore);
            if (actuallyStored > 0) {
                int previousLevel = player.field_71068_ca;
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, -actuallyStored));
                EnchantmentUtils.addPlayerXP(player, -actuallyStored);
                if (previousLevel != player.field_71068_ca) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.field_71068_ca));
                }
            }
            if (!world.field_72995_K) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.35f + 0.9f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!player.func_225608_bj_() && storedXP > 0) {
            if (((Boolean)Configuration.CONFIG.retriveUntilNextLevel.get()).booleanValue()) {
                int xpForPlayer = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca + 1) - EnchantmentUtils.getPlayerXP(player);
                int xpToRetrieve = (int)Math.floor((double)xpForPlayer / (Double)Configuration.CONFIG.retrievalPercentage.get());
                int actuallyRemoved = this.removeXP(stack, xpToRetrieve);
                if (actuallyRemoved < xpForPlayer) {
                    xpForPlayer = (int)Math.floor((double)actuallyRemoved * (Double)Configuration.CONFIG.retrievalPercentage.get());
                }
                this.addOrSpawnXPForPlayer(player, xpForPlayer);
            } else {
                this.addOrSpawnXPForPlayer(player, (int)Math.ceil((double)storedXP * (Double)Configuration.CONFIG.retrievalPercentage.get()));
                this.setStoredXP(stack, 0);
            }
            if (!world.field_72995_K && !((Boolean)Configuration.CONFIG.retrieveXPOrbs.get()).booleanValue()) {
                float pitchMultiplier = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private void addOrSpawnXPForPlayer(PlayerEntity player, int amount) {
        if (((Boolean)Configuration.CONFIG.retrieveXPOrbs.get()).booleanValue()) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), amount));
            }
        } else {
            int previousLevel = player.field_71068_ca;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.field_71068_ca) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.field_71068_ca));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(0.0, 1.0 - (double)this.getStoredXP(stack) / (double)((Integer)Configuration.CONFIG.maxXP.get()).intValue());
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getStoredXP(stack) > 0;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(TOOLTIP_1);
        tooltip.add(TOOLTIP_2);
        tooltip.add((ITextComponent)new TranslationTextComponent("xpbook.tooltip.3", new Object[]{this.getStoredXP(stack), Configuration.CONFIG.maxXP.get()}).func_230530_a_(TOOLTIP_STYLE));
    }

    public int addXP(ItemStack stack, int amount) {
        int maxStorage;
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored >= (maxStorage = ((Integer)Configuration.CONFIG.maxXP.get()).intValue())) {
            return 0;
        }
        if (stored + amount <= maxStorage) {
            this.setStoredXP(stack, stored + amount);
            return amount;
        }
        this.setStoredXP(stack, maxStorage);
        return maxStorage - stored;
    }

    public int removeXP(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored <= 0) {
            return 0;
        }
        if (stored >= amount) {
            this.setStoredXP(stack, stored - amount);
            return amount;
        }
        this.setStoredXP(stack, 0);
        return stored;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("xp", amount);
    }

    public int getStoredXP(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("xp");
    }
}

