/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.client.renderer.GuardRenderer;
import tallestegg.guardvillagers.client.renderer.GuardSteveRenderer;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardEntity;
import tallestegg.guardvillagers.items.DeferredSpawnEggItem;

@Mod(value="guardvillagers")
public class GuardVillagers {
    public static final String MODID = "guardvillagers";

    public GuardVillagers() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GuardConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, GuardConfig.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GuardEntityType.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        GuardPacketHandler.registerPackets();
    }

    private void setup(FMLCommonSetupEvent event) {
        if (GuardConfig.IllusionerRaids) {
            Raid.WaveMember.create((String)"thebluemengroup", (EntityType)EntityType.field_200764_D, (int[])new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        }
        event.enqueueWork(() -> GlobalEntityTypeAttributes.put((EntityType)((EntityType)GuardEntityType.GUARD.get()), (AttributeModifierMap)GuardEntity.createAttributes().func_233813_a_()));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        if (GuardConfig.guardSteve) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)GuardEntityType.GUARD.get()), GuardSteveRenderer::new);
        } else {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)GuardEntityType.GUARD.get()), GuardRenderer::new);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static boolean hotvChecker(PlayerEntity player) {
        return player.func_70644_a(Effects.field_220310_F) && GuardConfig.giveGuardStuffHOTV || !GuardConfig.giveGuardStuffHOTV;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onEntitiesRegistered(RegistryEvent.Register<EntityType<?>> event) {
            DeferredSpawnEggItem.initUnaddedEggs();
        }
    }
}

