/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.GuardLootTables;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.entities.ai.goals.ArmorerRepairGuardArmorGoal;
import tallestegg.guardvillagers.entities.ai.goals.FollowShieldGuards;
import tallestegg.guardvillagers.entities.ai.goals.GuardEatFoodGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardRunToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardSetRunningToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtByTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.KickGoal;
import tallestegg.guardvillagers.entities.ai.goals.RaiseShieldGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedBowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedCrossbowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RunToClericGoal;
import tallestegg.guardvillagers.entities.ai.goals.WalkBackToCheckPointGoal;
import tallestegg.guardvillagers.networking.GuardOpenInventoryPacket;

public class GuardEntity
extends CreatureEntity
implements ICrossbowUser,
IRangedAttackMob,
IAngerable,
IInventoryChangedListener {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(MODIFIER_UUID, "Use item speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Optional<BlockPos>> GUARD_POS = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> PATROLLING = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> GUARD_VARIANT = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> RUNNING_TO_EAT = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_CHARGING_STATE = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> KICKING = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FOLLOWING = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final Map<Pose, EntitySize> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)EntitySize.func_220314_b((float)0.6f, (float)1.95f)).put((Object)Pose.SLEEPING, (Object)field_213377_as).put((Object)Pose.FALL_FLYING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b((float)0.6f, (float)1.75f)).put((Object)Pose.DYING, (Object)EntitySize.func_220311_c((float)0.2f, (float)0.2f)).build();
    public Inventory guardInventory = new Inventory(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    private int field_234197_bv_;
    private static final RangedInteger angerTime = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID field_234198_bw_;
    private static final Map<EquipmentSlotType, ResourceLocation> EQUIPMENT_SLOT_ITEMS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlotType.MAINHAND, GuardLootTables.GUARD_MAIN_HAND);
        slotItems.put(EquipmentSlotType.OFFHAND, GuardLootTables.GUARD_OFF_HAND);
        slotItems.put(EquipmentSlotType.HEAD, GuardLootTables.GUARD_HELMET);
        slotItems.put(EquipmentSlotType.CHEST, GuardLootTables.GUARD_CHEST);
        slotItems.put(EquipmentSlotType.LEGS, GuardLootTables.GUARD_LEGGINGS);
        slotItems.put(EquipmentSlotType.FEET, GuardLootTables.GUARD_FEET);
    });
    private LazyOptional<?> itemHandler;

    public GuardEntity(EntityType<? extends GuardEntity> type, World world) {
        super(type, world);
        this.guardInventory.func_110134_a((IInventoryChangedListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.guardInventory));
        this.func_110163_bv();
        if (GuardConfig.GuardsOpenDoors) {
            ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_110163_bv();
        int type = GuardEntity.getRandomTypeForBiome((IWorld)this.field_70170_p, this.func_233580_cy_());
        if (spawnDataIn instanceof GuardData) {
            type = ((GuardData)spawnDataIn).variantData;
            spawnDataIn = new GuardData(type);
        }
        this.setGuardVariant(type);
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof CreatureEntity) {
            boolean attackTargets;
            CreatureEntity living = (CreatureEntity)entityIn;
            boolean bl = attackTargets = living.func_70638_az() instanceof VillagerEntity || living.func_70638_az() instanceof IronGolemEntity || living.func_70638_az() instanceof GuardEntity;
            if (attackTargets) {
                this.func_70624_b((LivingEntity)living);
            }
        }
        super.func_82167_n(entityIn);
    }

    @Nullable
    public void setPatrolPos(BlockPos position) {
        this.field_70180_af.func_187227_b(GUARD_POS, Optional.ofNullable(position));
    }

    @Nullable
    public BlockPos getPatrolPos() {
        return ((Optional)this.field_70180_af.func_187225_a(GUARD_POS)).orElse(null);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.func_184585_cz()) {
            return SoundEvents.field_187767_eL;
        }
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public static int slotToInventoryIndex(EquipmentSlotType slot) {
        switch (slot) {
            case CHEST: {
                return 1;
            }
            case FEET: {
                return 3;
            }
            case HEAD: {
                return 0;
            }
            case LEGS: {
                return 2;
            }
        }
        return 0;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        for (int i = 0; i < this.guardInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.guardInventory.func_70301_a(i);
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
            this.func_199701_a_(itemstack);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        int i;
        UUID uuid;
        super.func_70037_a(compound);
        UUID uUID = uuid = compound.func_186855_b("Owner") ? compound.func_186857_a("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.setGuardVariant(compound.func_74762_e("Type"));
        this.kickTicks = compound.func_74762_e("KickTicks");
        this.setFollowing(compound.func_74767_n("Following"));
        this.interacting = compound.func_74767_n("Interacting");
        this.setEating(compound.func_74767_n("Eating"));
        this.setPatrolling(compound.func_74767_n("Patrolling"));
        this.setRunningToEat(compound.func_74767_n("RunningToEat"));
        this.shieldCoolDown = compound.func_74762_e("KickCooldown");
        this.kickCoolDown = compound.func_74762_e("ShieldCooldown");
        if (compound.func_74764_b("PatrolPosX")) {
            int x = compound.func_74762_e("PatrolPosX");
            int y = compound.func_74762_e("PatrolPosY");
            int z = compound.func_74762_e("PatrolPosZ");
            this.field_70180_af.func_187227_b(GUARD_POS, Optional.ofNullable(new BlockPos(x, y, z)));
        }
        ListNBT listnbt = compound.func_150295_c("Inventory", 10);
        for (int i2 = 0; i2 < listnbt.size(); ++i2) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i2);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            this.guardInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
        if (compound.func_150297_b("ArmorItems", 9)) {
            ListNBT armorItems = compound.func_150295_c("ArmorItems", 10);
            for (i = 0; i < this.field_184657_bw.size(); ++i) {
                int index = GuardEntity.slotToInventoryIndex(MobEntity.func_184640_d((ItemStack)ItemStack.func_199557_a((CompoundNBT)armorItems.func_150305_b(i))));
                this.guardInventory.func_70299_a(index, ItemStack.func_199557_a((CompoundNBT)armorItems.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            ListNBT handItems = compound.func_150295_c("HandItems", 10);
            for (i = 0; i < this.field_184656_bv.size(); ++i) {
                int handSlot = i == 0 ? 5 : 4;
                this.guardInventory.func_70299_a(handSlot, ItemStack.func_199557_a((CompoundNBT)handItems.func_150305_b(i)));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Type", this.getGuardVariant());
        compound.func_74768_a("KickTicks", this.kickTicks);
        compound.func_74768_a("ShieldCooldown", this.shieldCoolDown);
        compound.func_74768_a("KickCooldown", this.kickCoolDown);
        compound.func_74757_a("Following", this.isFollowing());
        compound.func_74757_a("Interacting", this.interacting);
        compound.func_74757_a("Eating", this.isEating());
        compound.func_74757_a("Patrolling", this.isPatrolling());
        compound.func_74757_a("RunningToEat", this.isRunningToEat());
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.guardInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.guardInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("Inventory", (INBT)listnbt);
        if (this.getPatrolPos() != null) {
            compound.func_74768_a("PatrolPosX", this.getPatrolPos().func_177958_n());
            compound.func_74768_a("PatrolPosY", this.getPatrolPos().func_177956_o());
            compound.func_74768_a("PatrolPosZ", this.getPatrolPos().func_177952_p());
        }
        this.func_233682_c_(compound);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null || uuid != null && this.field_70170_p.func_217371_b(uuid) != null && !this.field_70170_p.func_217371_b(uuid).func_70644_a(Effects.field_220310_F) ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).func_233627_a_(1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.func_70625_a(entityIn, 90.0f, 90.0f);
        }
        ItemStack hand = this.func_184614_ca();
        hand.func_222118_a(1, (LivingEntity)this, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return super.func_70652_k(entityIn);
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_71036_o() {
        super.func_71036_o();
        if (this.func_184592_cb().func_77973_b() instanceof PotionItem && !(this.func_184592_cb().func_77973_b() instanceof SplashPotionItem)) {
            this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_151069_bo));
        }
        if (this.func_184592_cb().func_77973_b() instanceof MilkBucketItem) {
            this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        if (stack.func_222117_E()) {
            this.func_70691_i(stack.func_77973_b().func_219967_s().func_221466_a());
        }
        super.func_213357_a(world, stack);
        world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.setEating(false);
        return stack;
    }

    public void func_70636_d() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 200 == 0) {
            this.func_70691_i(GuardConfig.amountOfHealthRegenerated);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return SIZE_BY_POSE.getOrDefault(poseIn, EntitySize.func_220314_b((float)0.6f, (float)1.95f));
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (poseIn == Pose.CROUCHING) {
            return 1.4f;
        }
        return super.func_213348_b(poseIn, sizeIn);
    }

    protected void func_190629_c(LivingEntity entityIn) {
        super.func_190629_c(entityIn);
        if (entityIn.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    protected void func_184590_k(float damage) {
        if (this.field_184627_bm.isShield((LivingEntity)this) && damage >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, entity -> entity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public void func_184598_c(Hand hand) {
        ItemStack itemstack = this.func_184586_b(hand);
        if (itemstack.isShield((LivingEntity)this)) {
            ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
            modifiableattributeinstance.func_111124_b(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.func_233767_b_(USE_ITEM_SPEED_PENALTY);
        }
        super.func_184598_c(hand);
    }

    public void func_184602_cy() {
        if (this.func_110148_a(Attributes.field_233821_d_).func_180374_a(USE_ITEM_SPEED_PENALTY)) {
            this.func_110148_a(Attributes.field_233821_d_).func_111124_b(USE_ITEM_SPEED_PENALTY);
        }
        super.func_184602_cy();
    }

    public void disableShield(boolean increase) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (increase) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.shieldCoolDown = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DATA_CHARGING_STATE, (Object)false);
        this.field_70180_af.func_187214_a(KICKING, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(EATING, (Object)false);
        this.field_70180_af.func_187214_a(FOLLOWING, (Object)false);
        this.field_70180_af.func_187214_a(GUARD_POS, Optional.empty());
        this.field_70180_af.func_187214_a(PATROLLING, (Object)false);
        this.field_70180_af.func_187214_a(RUNNING_TO_EAT, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CHARGING_STATE);
    }

    public void func_213671_a(boolean charging) {
        this.field_70180_af.func_187227_b(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.field_70180_af.func_187225_a(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.field_70180_af.func_187227_b(KICKING, (Object)kicking);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            for (ItemStack stack : this.getItemsFromLootTable(equipmentslottype)) {
                this.func_184201_a(equipmentslottype, stack);
            }
        }
        this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 100.0f;
        this.field_82174_bp[EquipmentSlotType.OFFHAND.func_188454_b()] = 100.0f;
    }

    public List<ItemStack> getItemsFromLootTable(EquipmentSlotType slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            LootTable loot = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(EQUIPMENT_SLOT_ITEMS.get(slot));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216023_a(this.func_70681_au());
            return loot.func_216113_a(lootcontext$builder.func_216022_a(GuardLootTables.SLOT));
        }
        return null;
    }

    public int getGuardVariant() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_VARIANT);
    }

    public void setGuardVariant(int typeId) {
        this.field_70180_af.func_187227_b(GUARD_VARIANT, (Object)typeId);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)GuardItems.GUARD_SPAWN_EGG.get());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new KickGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new GuardEatFoodGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RaiseShieldGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GuardRunToEatGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GuardSetRunningToEatGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f));
        this.field_70714_bg.func_75776_a(2, new RangedBowAttackPassiveGoal<GuardEntity>(this, 0.5, 20, 15.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new GuardMeleeGoal(this, 0.8, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowHeroGoal(this));
        if (GuardConfig.GuardsRunFromPolarBears) {
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 12.0f, 1.0, 1.2));
        }
        this.field_70714_bg.func_75776_a(3, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.5, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.5, false, 4, () -> false));
        if (GuardConfig.GuardsOpenDoors) {
            this.field_70714_bg.func_75776_a(3, (Goal)new OpenDoorGoal((MobEntity)this, true){

                public void func_75249_e() {
                    super.func_75249_e();
                    this.field_75356_a.func_184609_a(Hand.MAIN_HAND);
                }
            });
        }
        if (GuardConfig.GuardFormation) {
            this.field_70714_bg.func_75776_a(5, (Goal)new FollowShieldGuards(this));
        }
        if (GuardConfig.ClericHealing) {
            this.field_70714_bg.func_75776_a(6, (Goal)new RunToClericGoal(this));
        }
        if (GuardConfig.armorerRepairGuardArmor) {
            this.field_70714_bg.func_75776_a(6, (Goal)new ArmorerRepairGuardArmorGoal(this));
        }
        this.field_70714_bg.func_75776_a(4, (Goal)new WalkBackToCheckPointGoal(this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, AbstractVillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(5, (Goal)new DefendVillageGuardGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RavagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{GuardEntity.class, IronGolemEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitchEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new HeroHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HeroHurtTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRaiderEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IllusionerEntity.class, true));
        if (GuardConfig.AttackAllMobs) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, true, true, mob -> mob instanceof IMob && !GuardConfig.MobBlackList.contains(mob.func_70022_Q())));
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((GuardEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.shieldCoolDown = 8;
        if (this.func_184614_ca().func_77973_b() instanceof CrossbowItem) {
            this.func_234281_b_((LivingEntity)this, 6.0f);
        }
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            ItemStack itemstack = this.func_213356_f(this.func_184586_b(GuardItems.getHandWith((LivingEntity)this, (com.google.common.base.Predicate<Item>)((com.google.common.base.Predicate)item -> item instanceof BowItem))));
            ItemStack hand = this.func_184614_ca();
            hand.func_222118_a(1, (LivingEntity)this, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
        }
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        switch (slotIn) {
            case CHEST: {
                if (!this.guardInventory.func_70301_a(1).func_190926_b()) break;
                this.guardInventory.func_70299_a(1, (ItemStack)this.field_184657_bw.get(slotIn.func_188454_b()));
                break;
            }
            case FEET: {
                if (!this.guardInventory.func_70301_a(3).func_190926_b()) break;
                this.guardInventory.func_70299_a(3, (ItemStack)this.field_184657_bw.get(slotIn.func_188454_b()));
                break;
            }
            case HEAD: {
                if (!this.guardInventory.func_70301_a(0).func_190926_b()) break;
                this.guardInventory.func_70299_a(0, (ItemStack)this.field_184657_bw.get(slotIn.func_188454_b()));
                break;
            }
            case LEGS: {
                if (!this.guardInventory.func_70301_a(2).func_190926_b()) break;
                this.guardInventory.func_70299_a(2, (ItemStack)this.field_184657_bw.get(slotIn.func_188454_b()));
                break;
            }
            case MAINHAND: {
                if (!this.guardInventory.func_70301_a(5).func_190926_b()) break;
                this.guardInventory.func_70299_a(5, (ItemStack)this.field_184656_bv.get(slotIn.func_188454_b()));
                break;
            }
            case OFFHAND: {
                if (!this.guardInventory.func_70301_a(4).func_190926_b()) break;
                this.guardInventory.func_70299_a(4, (ItemStack)this.field_184656_bv.get(slotIn.func_188454_b()));
            }
        }
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        if (shootable.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d();
            ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (!this.interacting) {
            super.func_213352_e(travelVector);
        }
    }

    public boolean isFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.field_70180_af.func_187227_b(FOLLOWING, (Object)following);
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.isOwner(target) && !(target instanceof VillagerEntity) && super.func_213336_c(target);
    }

    public static int getRandomTypeForBiome(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        switch (biome.func_201856_r()) {
            case DESERT: 
            case MESA: {
                return 1;
            }
            case ICY: {
                return 6;
            }
            case JUNGLE: {
                return 4;
            }
            case NONE: {
                return 0;
            }
            case PLAINS: {
                return 0;
            }
            case SAVANNA: {
                return 2;
            }
            case SWAMP: {
                return 3;
            }
            case TAIGA: {
                return 5;
            }
        }
        return 0;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity creatureentity = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = creatureentity.field_70761_aq;
        }
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public void func_230284_a_(LivingEntity arg0, ItemStack arg1, ProjectileEntity arg2, float arg3) {
        this.func_234279_a_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void func_213371_e(LivingEntity entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.func_213371_e((LivingEntity)this);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean inventoryRequirements;
        boolean configValues = !GuardConfig.giveGuardStuffHOTV || !GuardConfig.setGuardPatrolHotv || player.func_70644_a(Effects.field_220310_F) && GuardConfig.giveGuardStuffHOTV || player.func_70644_a(Effects.field_220310_F) && GuardConfig.setGuardPatrolHotv || player.func_70644_a(Effects.field_220310_F) && GuardConfig.giveGuardStuffHOTV && GuardConfig.setGuardPatrolHotv;
        boolean bl = inventoryRequirements = !player.func_226563_dT_() && this.field_70122_E;
        if (configValues && inventoryRequirements) {
            if (this.func_70638_az() != player && this.func_70613_aW() && player instanceof ServerPlayerEntity) {
                this.openGui((ServerPlayerEntity)player);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        int i = inventorySlot - 400;
        if (i >= 0 && i < 2 && i < this.guardInventory.func_70302_i_()) {
            if (i == 0) {
                return false;
            }
            if (itemStackIn.func_77973_b() instanceof ArmorItem) {
                this.guardInventory.func_70299_a(i, itemStackIn);
                return true;
            }
            return false;
        }
        int j = inventorySlot - 500 + 2;
        if (j >= 2 && j < this.guardInventory.func_70302_i_()) {
            this.guardInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    protected void playHealEffect() {
        BasicParticleType iparticledata = ParticleTypes.field_197632_y;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public static String getNameByType(int id) {
        switch (id) {
            case 0: {
                return "plains";
            }
            case 1: {
                return "desert";
            }
            case 2: {
                return "savanna";
            }
            case 3: {
                return "swamp";
            }
            case 4: {
                return "jungle";
            }
            case 5: {
                return "taiga";
            }
            case 6: {
                return "snow";
            }
        }
        return "";
    }

    public void func_76316_a(IInventory invBasic) {
    }

    protected void func_230294_b_(DamageSource damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.guardInventory.func_70301_a(i);
                if (damageSource.func_76347_k() && itemstack.func_77973_b().func_234687_u_() || !(itemstack.func_77973_b() instanceof ArmorItem)) continue;
                int j = i;
                itemstack.func_222118_a((int)damage, (LivingEntity)this, p_214023_1_ -> p_214023_1_.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)j)));
            }
        }
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        if (p_241841_1_.func_175659_aa() != Difficulty.PEACEFUL) {
            WitchEntity witchentity = (WitchEntity)EntityType.field_200759_ay.func_200721_a((World)p_241841_1_);
            if (witchentity == null) {
                return;
            }
            witchentity.func_82149_j((Entity)this);
            witchentity.func_213386_a((IServerWorld)p_241841_1_, p_241841_1_.func_175649_E(witchentity.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
            witchentity.func_94061_f(this.func_175446_cd());
            witchentity.func_200203_b(this.func_200201_e());
            witchentity.func_174805_g(this.func_174833_aM());
            witchentity.func_110163_bv();
            p_241841_1_.func_242417_l((Entity)witchentity);
            this.func_70106_y();
        } else {
            super.func_241841_a(p_241841_1_, p_241841_2_);
        }
    }

    public UUID func_230257_G__() {
        return this.field_234198_bw_;
    }

    public int func_230256_F__() {
        return this.field_234197_bv_;
    }

    public void func_230259_a_(UUID arg0) {
        this.field_234198_bw_ = arg0;
    }

    public void func_230260_a__(int arg0) {
        this.field_234197_bv_ = arg0;
    }

    public void func_230258_H__() {
        this.func_230260_a__(angerTime.func_233018_a_(this.field_70146_Z));
    }

    public void openGui(ServerPlayerEntity player) {
        if (player.field_71070_bA != player.field_71069_bz) {
            player.func_71053_j();
        }
        this.interacting = true;
        player.func_71117_bO();
        GuardPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GuardOpenInventoryPacket(player.field_71139_cq, this.guardInventory.func_70302_i_(), this.func_145782_y()));
        player.field_71070_bA = new GuardContainer(player.field_71139_cq, player.field_71071_by, (IInventory)this.guardInventory, this);
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, player.field_71070_bA));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, GuardConfig.GuardHealth).func_233815_a_(Attributes.field_233821_d_, GuardConfig.GuardSpeed).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, GuardConfig.GuardFollowRange);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEating(boolean eating) {
        this.field_70180_af.func_187227_b(EATING, (Object)eating);
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_70180_af.func_187225_a(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.field_70180_af.func_187227_b(PATROLLING, (Object)patrolling);
    }

    public boolean isRunningToEat() {
        return (Boolean)this.field_70180_af.func_187225_a(RUNNING_TO_EAT);
    }

    public void setRunningToEat(boolean running) {
        this.field_70180_af.func_187227_b(RUNNING_TO_EAT, (Object)running);
    }

    public class GuardMeleeGoal
    extends MeleeAttackGoal {
        public final GuardEntity guard;

        public GuardMeleeGoal(GuardEntity guard, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean func_75250_a() {
            return !(this.guard.func_184614_ca().func_77973_b() instanceof CrossbowItem) && this.guard.func_70638_az() != null && !this.guard.isEating() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.guard.func_70638_az() != null && !(this.guard.func_184614_ca().func_77973_b() instanceof CrossbowItem);
        }

        public void func_75246_d() {
            LivingEntity target = this.guard.func_70638_az();
            if (target != null) {
                if ((double)target.func_70032_d((Entity)this.guard) <= 3.0 && !this.guard.func_184585_cz()) {
                    this.guard.func_70605_aq().func_188488_a(-2.0f, 0.0f);
                    this.guard.func_70625_a((Entity)target, 30.0f, 30.0f);
                }
                if (this.field_75438_g != null && (double)target.func_70032_d((Entity)this.guard) <= 2.0) {
                    this.guard.func_70661_as().func_75499_g();
                }
                super.func_75246_d();
            }
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return super.func_179512_a(attackTarget) * 3.55;
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_234037_i_ <= 0) {
                this.func_234039_g_();
                this.guard.func_184602_cy();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.func_184609_a(Hand.MAIN_HAND);
                this.guard.func_70652_k((Entity)enemy);
            }
        }
    }

    public static class FollowHeroGoal
    extends Goal {
        public final GuardEntity guard;

        public FollowHeroGoal(GuardEntity mob) {
            this.guard = mob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (this.guard.getOwner() != null) {
                this.guard.func_70661_as().func_75497_a((Entity)this.guard.getOwner(), 0.9);
            }
        }

        public void func_75246_d() {
            if (this.guard.getOwner() != null) {
                this.guard.func_70661_as().func_75497_a((Entity)this.guard.getOwner(), 0.9);
            }
        }

        public boolean func_75253_b() {
            return this.guard.isFollowing() && this.func_75250_a();
        }

        public boolean func_75250_a() {
            List list = this.guard.field_70170_p.func_217357_a(PlayerEntity.class, this.guard.func_174813_aQ().func_186662_g(10.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    PlayerEntity player = (PlayerEntity)mob;
                    if (player.func_82150_aj() || !player.func_70644_a(Effects.field_220310_F)) continue;
                    this.guard.setOwnerId(player.func_110124_au());
                    return this.guard.isFollowing();
                }
            }
            return false;
        }

        public void func_75251_c() {
            this.guard.func_70661_as().func_75499_g();
            if (this.guard.getOwner() != null && !this.guard.getOwner().func_70644_a(Effects.field_220310_F)) {
                this.guard.setOwnerId(null);
                this.guard.setFollowing(false);
            }
        }
    }

    public static class DefendVillageGuardGoal
    extends TargetGoal {
        private final GuardEntity guard;
        private LivingEntity villageAggressorTarget;

        public DefendVillageGuardGoal(GuardEntity guardIn) {
            super((MobEntity)guardIn, false, true);
            this.guard = guardIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            AxisAlignedBB axisalignedbb = this.guard.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0);
            List list = this.guard.field_70170_p.func_217357_a(VillagerEntity.class, axisalignedbb);
            List list1 = this.guard.field_70170_p.func_217357_a(PlayerEntity.class, axisalignedbb);
            for (LivingEntity livingentity : list) {
                VillagerEntity villagerentity = (VillagerEntity)livingentity;
                for (PlayerEntity playerentity : list1) {
                    int i = villagerentity.func_223107_f(playerentity);
                    if (i > -100) continue;
                    this.villageAggressorTarget = playerentity;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.func_175149_v() && !((PlayerEntity)this.villageAggressorTarget).func_184812_l_();
        }

        public void func_75249_e() {
            this.guard.func_70624_b(this.villageAggressorTarget);
            super.func_75249_e();
        }
    }

    public static class GuardData
    implements ILivingEntityData {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }
}

