/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.treeharvester.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Util {
    public static HashMap<BlockPos, Integer> highestleaf = new HashMap();
    public static CopyOnWriteArrayList<Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>> lowerlogs = new CopyOnWriteArrayList();

    public static int isTreeAndReturnLogAmount(World world, BlockPos pos) {
        highestleaf.put(pos, 0);
        int leafcount = 20;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block nblock = world.func_180495_p(npos).func_177230_c();
                if (Util.isTreeLeaf(nblock)) {
                    --leafcount;
                    if (npos.func_177956_o() <= highesty) continue;
                    highesty = npos.func_177956_o();
                    continue;
                }
                if (!Util.isTreeLog(nblock)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.func_185334_h(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static boolean isTreeLeaf(Block block) {
        return block instanceof LeavesBlock || block instanceof BushBlock;
    }

    public static boolean isTreeLog(Block block) {
        return block instanceof RotatedPillarBlock;
    }

    public static boolean isSapling(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        return Block.func_149634_a((Item)item) instanceof SaplingBlock;
    }

    public static List<BlockPos> getAllLogsToBreak(World world, BlockPos pos, int logcount) {
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150346_d)) {
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block block = world.func_180495_p(npos).func_177230_c();
                if (!Util.isTreeLog(block)) continue;
                bottomlogs.add(npos.func_185334_h());
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue()) {
            if (((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
                Util.replaceSapling(world, pos, bottomlogs, 1);
            } else if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue()) {
                lowerlogs.add((Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>)new Pair((Object)pos.func_185334_h(), bottomlogs));
            }
        }
        return Util.getLogsToBreak(world, pos, new ArrayList<BlockPos>(), logcount);
    }

    public static void replaceSapling(World world, BlockPos pos, CopyOnWriteArrayList<BlockPos> bottomlogs, int radius) {
        int reducecount;
        int rc = reducecount = bottomlogs.size();
        ItemStack sapling = null;
        for (Entity ea : world.func_72839_b(null, new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + 30), (double)(pos.func_177952_p() + radius)))) {
            int count;
            ItemEntity eia;
            ItemStack eisa;
            if (!(ea instanceof ItemEntity) || !Util.isSapling(eisa = (eia = (ItemEntity)ea).func_92059_d())) continue;
            if (sapling == null) {
                sapling = eisa.func_77946_l();
            }
            if ((count = eisa.func_190916_E()) > 1) {
                for (int n = 0; n < count; ++n) {
                    eisa.func_190918_g(1);
                    if (--rc == 0) break;
                }
                eia.func_92058_a(eisa);
            } else {
                --rc;
                eia.func_70106_y();
            }
            if (rc != 0) continue;
            break;
        }
        int setsaplings = bottomlogs.size() - rc;
        for (BlockPos bottompos : bottomlogs) {
            if (setsaplings == 0) break;
            world.func_175656_a(bottompos, Block.func_149634_a((Item)sapling.func_77973_b()).func_176223_P());
            --setsaplings;
            bottomlogs.remove(bottompos);
        }
        if (bottomlogs.size() > 0) {
            if (radius >= 5) {
                return;
            }
            Util.replaceSapling(world, pos, bottomlogs, radius + 2);
        }
    }

    private static List<BlockPos> getLogsToBreak(World world, BlockPos pos, List<BlockPos> logstobreak, int logcount) {
        ArrayList<Object> checkaround = new ArrayList<Object>();
        Iterator aroundlogs = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            BlockState blockState;
            Block logblock;
            BlockPos nalogpos = ((BlockPos)aroundlogs.next()).func_185334_h();
            if (logstobreak.contains(nalogpos) || !Util.isTreeLog(logblock = (blockState = world.func_180495_p(nalogpos)).func_177230_c())) continue;
            checkaround.add(nalogpos);
            logstobreak.add(nalogpos);
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(logcount);
            int h = (Integer)hv.getFirst();
            int v = (Integer)hv.getSecond();
            Iterator aroundleaves = BlockPos.func_218287_a((int)(pos.func_177958_n() - h), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - h), (int)(pos.func_177958_n() + h), (int)(pos.func_177956_o() + v), (int)(pos.func_177952_p() + h)).iterator();
            while (aroundleaves.hasNext()) {
                BlockPos naleafpos = (BlockPos)aroundleaves.next();
                Block leafblock = world.func_180495_p(naleafpos).func_177230_c();
                if (!Util.isTreeLeaf(leafblock) || !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) continue;
                world.func_175655_b(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return logstobreak;
        }
        for (BlockPos blockPos : checkaround) {
            for (BlockPos logpos : Util.getLogsToBreak(world, blockPos, logstobreak, logcount)) {
                if (logstobreak.contains(logpos)) continue;
                logstobreak.add(logpos.func_185334_h());
            }
        }
        BlockPos up = pos.func_177981_b(2);
        return Util.getLogsToBreak(world, up.func_185334_h(), logstobreak, logcount);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(int logcount) {
        int h = 3;
        int v = 4;
        if (logcount >= 20) {
            h = 5;
            v = 5;
        } else if (logcount >= 10) {
            h = 4;
            v = 5;
        }
        return new Pair((Object)h, (Object)v);
    }
}

