/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.ActionColor;
import de.diddiz.util.TypeColor;
import de.diddiz.util.Utils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;

public class MessagingUtil {
    public static BaseComponent[] formatSummarizedChanges(int created, int destroyed, BaseComponent actor, int createdWidth, int destroyedWidth, float spaceFactor) {
        TextComponent textCreated = MessagingUtil.createTextComponentWithColor(created + Utils.spaces((int)((float)(10 - String.valueOf(created).length()) / spaceFactor)), ActionColor.CREATE.getColor());
        TextComponent textDestroyed = MessagingUtil.createTextComponentWithColor(destroyed + Utils.spaces((int)((float)(10 - String.valueOf(destroyed).length()) / spaceFactor)), ActionColor.DESTROY.getColor());
        return new BaseComponent[]{textCreated, textDestroyed, actor};
    }

    public static TextComponent createTextComponentWithColor(String text, ChatColor color) {
        TextComponent tc = new TextComponent(text);
        tc.setColor(color);
        return tc;
    }

    public static TextComponent brackets(BracketType type, BaseComponent ... content) {
        TextComponent tc = MessagingUtil.createTextComponentWithColor(type.getStarting(), TypeColor.BRACKETS.getColor());
        for (BaseComponent c : content) {
            tc.addExtra(c);
        }
        tc.addExtra((BaseComponent)new TextComponent(type.getEnding()));
        return tc;
    }

    public static TextComponent prettyDate(long date) {
        TextComponent tc = MessagingUtil.brackets(BracketType.STANDARD, new BaseComponent[]{MessagingUtil.createTextComponentWithColor(Config.formatterShort.format(date), TypeColor.DATE.getColor())});
        tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Config.formatter.format(date))}));
        return tc;
    }

    public static TextComponent prettyState(String stateName) {
        return MessagingUtil.createTextComponentWithColor(stateName, TypeColor.STATE.getColor());
    }

    public static TextComponent prettyState(int stateValue) {
        return MessagingUtil.prettyState(Integer.toString(stateValue));
    }

    public static <E extends Enum<E>> TextComponent prettyState(E enumerator) {
        return MessagingUtil.prettyState(enumerator.toString());
    }

    public static TextComponent prettyMaterial(String materialName) {
        return MessagingUtil.createTextComponentWithColor(materialName.toUpperCase(), TypeColor.MATERIAL.getColor());
    }

    public static TextComponent prettyMaterial(Material material) {
        return MessagingUtil.prettyMaterial(material.name());
    }

    public static TextComponent prettyMaterial(BlockData material) {
        int bracket2;
        TextComponent tc = MessagingUtil.prettyMaterial(material.getMaterial());
        String bdString = material.getAsString();
        int bracket = bdString.indexOf("[");
        if (bracket >= 0 && (bracket2 = bdString.indexOf("]", bracket)) >= 0) {
            String state = bdString.substring(bracket + 1, bracket2).replace(',', '\n');
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(state)}));
        }
        return tc;
    }

    public static TextComponent prettyEntityType(EntityType type) {
        return MessagingUtil.prettyMaterial(type.name());
    }

    public static TextComponent prettyLocation(Location loc, int entryId) {
        return MessagingUtil.prettyLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), entryId);
    }

    public static TextComponent prettyLocation(int x, int y, int z, int entryId) {
        TextComponent tc = MessagingUtil.createTextComponentWithColor("", TypeColor.DEFAULT.getColor());
        tc.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(Integer.toString(x), TypeColor.COORDINATE.getColor()));
        tc.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(", ", TypeColor.DEFAULT.getColor()));
        tc.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(Integer.toString(y), TypeColor.COORDINATE.getColor()));
        tc.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(", ", TypeColor.DEFAULT.getColor()));
        tc.addExtra((BaseComponent)MessagingUtil.createTextComponentWithColor(Integer.toString(z), TypeColor.COORDINATE.getColor()));
        if (entryId > 0) {
            tc.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lb tp " + entryId));
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Teleport here")}));
        }
        return tc;
    }

    public static enum BracketType {
        STANDARD("[", "]"),
        ANGLE("<", ">");

        private String starting;
        private String ending;

        private BracketType(String starting, String ending) {
            this.starting = starting;
            this.ending = ending;
        }

        public String getStarting() {
            return this.starting;
        }

        public String getEnding() {
            return this.ending;
        }
    }
}

