/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.client;

import com.therandomlabs.randompatches.RPConfig;
import com.therandomlabs.randompatches.RandomPatches;
import java.util.List;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WithNarratorSettingsScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.ArrayUtils;

public final class RPKeyBindingHandler {
    private static boolean enabled;

    private RPKeyBindingHandler() {
    }

    public static void enable() {
        if (FMLEnvironment.dist == Dist.CLIENT && !enabled) {
            enabled = true;
            RPKeyBindingHandler.onConfigReload();
        }
    }

    public static void onConfigReload() {
        if (FMLEnvironment.dist == Dist.CLIENT && enabled) {
            KeyBindings.register();
        }
    }

    private static final class ToggleNarratorKeyConflictContext
    implements IKeyConflictContext {
        private static final ToggleNarratorKeyConflictContext INSTANCE = new ToggleNarratorKeyConflictContext();

        private ToggleNarratorKeyConflictContext() {
        }

        public boolean isActive() {
            Screen screen = KeyBindings.mc.field_71462_r;
            return screen == null || !(screen.func_241217_q_() instanceof TextFieldWidget) || !((TextFieldWidget)screen.func_241217_q_()).func_212955_f();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return true;
        }

        static /* synthetic */ ToggleNarratorKeyConflictContext access$000() {
            return INSTANCE;
        }
    }

    public static final class KeyBindings {
        public static final KeyBinding SECONDARY_SPRINT = new KeyBinding("key.secondarySprint", 87, "key.categories.movement");
        public static final KeyBinding DISMOUNT = new KeyBinding("key.dismount", 340, "key.categories.gameplay");
        public static final KeyBinding TOGGLE_NARRATOR = new KeyBinding("key.narrator", (IKeyConflictContext)ToggleNarratorKeyConflictContext.access$000(), KeyModifier.CONTROL, InputMappings.Type.KEYSYM, 66, "key.categories.misc");
        public static final KeyBinding PAUSE = new KeyBinding("key.pause", 256, "key.categories.misc");
        public static final KeyBinding TOGGLE_GUI = new KeyBinding("key.gui", 290, "key.categories.misc");
        public static final KeyBinding TOGGLE_DEBUG_INFO = new KeyBinding("key.debugInfo", 292, "key.categories.misc");
        private static final Minecraft mc = Minecraft.func_71410_x();

        private KeyBindings() {
        }

        public static void onKeyEvent(int key, int action, int scanCode) {
            RPConfig.KeyBindings config = RandomPatches.config().client.keyBindings;
            if (config.toggleNarrator && action != 0 && TOGGLE_NARRATOR.isConflictContextAndModifierActive() && KeyBindings.matches(TOGGLE_NARRATOR, key, scanCode)) {
                AbstractOption.field_216715_v.func_216722_a(KeyBindings.mc.field_71474_y, 1);
                if (KeyBindings.mc.field_71462_r instanceof WithNarratorSettingsScreen) {
                    ((WithNarratorSettingsScreen)KeyBindings.mc.field_71462_r).func_243317_i();
                }
            }
            if (config.pause && action != 0 && KeyBindings.matches(PAUSE, key, scanCode)) {
                if (KeyBindings.mc.field_71462_r == null) {
                    mc.func_71385_j(InputMappings.func_216506_a((long)mc.func_228018_at_().func_198092_i(), (int)292));
                } else if (KeyBindings.mc.field_71462_r instanceof IngameMenuScreen) {
                    KeyBindings.mc.field_71462_r.func_231175_as__();
                }
            }
            if (KeyBindings.mc.field_71462_r != null && !KeyBindings.mc.field_71462_r.field_230711_n_) {
                return;
            }
            if (config.toggleGUI && action != 0 && KeyBindings.matches(TOGGLE_GUI, key, scanCode)) {
                boolean bl = KeyBindings.mc.field_71474_y.field_74319_N = !KeyBindings.mc.field_71474_y.field_74319_N;
            }
            if (config.toggleDebugInfo && action == 0 && KeyBindings.matches(TOGGLE_DEBUG_INFO, key, scanCode)) {
                if (TOGGLE_DEBUG_INFO.getKey().func_197938_b() == InputMappings.Type.KEYSYM && TOGGLE_DEBUG_INFO.getKey().func_197937_c() == 292 && KeyBindings.mc.field_195559_v.field_197975_d) {
                    KeyBindings.mc.field_195559_v.field_197975_d = false;
                } else {
                    KeyBindings.mc.field_71474_y.field_74330_P = !KeyBindings.mc.field_71474_y.field_74330_P;
                    KeyBindings.mc.field_71474_y.field_74329_Q = KeyBindings.mc.field_71474_y.field_74330_P && Screen.func_231173_s_();
                    KeyBindings.mc.field_71474_y.field_181657_aC = KeyBindings.mc.field_71474_y.field_74330_P && Screen.func_231174_t_();
                }
            }
        }

        private static boolean matches(KeyBinding keyBinding, int key, int scanCode) {
            return scanCode == Integer.MIN_VALUE ? keyBinding.func_197984_a(key) : keyBinding.func_197976_a(key, scanCode);
        }

        private static void register() {
            RPConfig.KeyBindings config = RandomPatches.config().client.keyBindings;
            List<String> mixinBlacklist = RandomPatches.config().misc.mixinBlacklist;
            KeyBindings.register(SECONDARY_SPRINT, config.secondarySprint());
            KeyBindings.register(DISMOUNT, config.dismount());
            if (!mixinBlacklist.contains("KeyboardListener")) {
                KeyBindings.register(TOGGLE_NARRATOR, config.toggleNarrator);
                KeyBindings.register(PAUSE, config.pause);
                KeyBindings.register(TOGGLE_GUI, config.toggleGUI);
                KeyBindings.register(TOGGLE_DEBUG_INFO, config.toggleDebugInfo);
            }
        }

        private static void register(KeyBinding keyBinding, boolean enabled) {
            if (enabled) {
                if (!ArrayUtils.contains((Object[])KeyBindings.mc.field_71474_y.field_74324_K, (Object)keyBinding)) {
                    KeyBindings.mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])KeyBindings.mc.field_71474_y.field_74324_K, (Object)keyBinding);
                }
            } else {
                int index = ArrayUtils.indexOf((Object[])KeyBindings.mc.field_71474_y.field_74324_K, (Object)keyBinding);
                if (index != -1) {
                    KeyBindings.mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.remove((Object[])KeyBindings.mc.field_71474_y.field_74324_K, (int)index);
                }
            }
        }
    }
}

