/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelAddedEvent;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelDisabledEvent;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelEnabledEvent;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelRemovedEvent;
import net.blay09.mods.twitchintegration.chat.TwitchChannel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwitchChannelManager {
    private static final Logger logger = LogManager.getLogger();
    private transient File file;
    private final Map<String, TwitchChannel> channels = new HashMap<String, TwitchChannel>();

    public Collection<TwitchChannel> getChannels() {
        return this.channels.values();
    }

    public void joinChannel(String channelName) {
        TwitchChannel channel = this.getChannel(channelName);
        if (channel == null) {
            channel = new TwitchChannel(channelName);
            this.addChannel(channel);
        }
        channel.setEnabled(true);
        MinecraftForge.EVENT_BUS.post((Event)new TwitchChannelEnabledEvent(channel));
        this.save();
    }

    public void leaveChannel(String channelName) {
        TwitchChannel channel = this.getChannel(channelName);
        if (channel != null) {
            channel.setEnabled(false);
            MinecraftForge.EVENT_BUS.post((Event)new TwitchChannelDisabledEvent(channel));
            this.save();
        }
    }

    private void addChannel(TwitchChannel channel) {
        this.channels.put(channel.getName().toLowerCase(Locale.ENGLISH), channel);
        MinecraftForge.EVENT_BUS.post((Event)new TwitchChannelAddedEvent(channel));
        this.save();
    }

    public void removeChannelByName(String channelName) {
        TwitchChannel removedChannel = this.channels.remove(channelName.toLowerCase(Locale.ENGLISH));
        MinecraftForge.EVENT_BUS.post((Event)new TwitchChannelRemovedEvent(removedChannel));
        this.save();
    }

    public void createDefaultChannelIfNotExists(String username) {
        if (!this.channels.containsKey(username.toLowerCase(Locale.ENGLISH))) {
            TwitchChannel channel = new TwitchChannel(username);
            channel.setEnabled(true);
            this.addChannel(channel);
        }
    }

    @Nullable
    public TwitchChannel getChannel(String channel) {
        if (channel.charAt(0) == '#') {
            channel = channel.substring(1);
        }
        return this.channels.get(channel.toLowerCase(Locale.ENGLISH));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TwitchChannelManager load(File file) {
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(file);){
            TwitchChannelManager twitchChannelManager2 = (TwitchChannelManager)gson.fromJson((Reader)reader, TwitchChannelManager.class);
            twitchChannelManager2.file = file;
            TwitchChannelManager twitchChannelManager = twitchChannelManager2;
            return twitchChannelManager;
        }
        catch (IOException e) {
            TwitchChannelManager twitchChannelManager3 = new TwitchChannelManager();
            twitchChannelManager3.file = file;
            return twitchChannelManager3;
        }
    }

    public void save() {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            logger.error("Could not save Twitch channel configs: ", (Throwable)e);
        }
    }
}

