/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TwitchIntegrationConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue useAnonymousLogin;
        public final ForgeConfigSpec.BooleanValue showWhispers;
        public final ForgeConfigSpec.BooleanValue disableUserColors;
        public final ForgeConfigSpec.BooleanValue disableNameBadges;
        public final ForgeConfigSpec.BooleanValue doNotStoreToken;
        public final ForgeConfigSpec.IntValue port;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> userBlacklist;

        Client(ForgeConfigSpec.Builder builder) {
            this.useAnonymousLogin = builder.comment("If you login anonymously you can read chat, but you will not be able to type to Twitch chat from within Minecraft.").translation("config.twitchchatintegration.useAnonymousLogin").define("useAnonymousLogin", false);
            this.showWhispers = builder.translation("config.twitchchatintegration.showWhispers").define("showWhispers", false);
            this.disableUserColors = builder.translation("config.twitchchatintegration.disableUserColors").define("disableUserColors", false);
            this.disableNameBadges = builder.translation("config.twitchchatintegration.disableNameBadges").define("disableNameBadges", false);
            this.doNotStoreToken = builder.comment("Set this if you're on a public computer or concerned about security. You will have to re-authenticate every time you start Minecraft.").translation("config.twitchchatintegration.doNotStoreToken").define("doNotStoreToken", false);
            this.port = builder.translation("config.twitchchatintegration.port").defineInRange("port", 6667, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.userBlacklist = builder.comment("Messages by these users will not display in chat. Useful to hide bots for example.").translation("config.twitchchatintegration.userBlacklist").defineList("userBlacklist", (List)Lists.newArrayList(), it -> it instanceof String);
        }
    }
}

