/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.TwitchChannelManager;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelDisabledEvent;
import net.blay09.mods.twitchintegration.api.event.TwitchChannelEnabledEvent;
import net.blay09.mods.twitchintegration.auth.TwitchAuthManager;
import net.blay09.mods.twitchintegration.auth.TwitchAuthToken;
import net.blay09.mods.twitchintegration.chat.TwitchChannel;
import net.blay09.mods.twitchintegration.handler.TwitchChatHandler;
import net.blay09.repack.javairc.IRCConfiguration;
import net.blay09.repack.javatmi.TMIClient;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="twitchchatintegration", value={Dist.CLIENT})
public class TwitchSessionManager {
    private static final Path channelConfigPath = FMLPaths.CONFIGDIR.get().resolve("twitchchatintegration_channels.json");
    private static final TwitchChatHandler twitchChatHandler = new TwitchChatHandler();
    private static TwitchChannelManager twitchChannelManager;
    private static final List<TwitchChannel> joinedChannels;
    private static TMIClient twitchClient;

    public static void init() {
        twitchChannelManager = TwitchChannelManager.load(channelConfigPath.toFile());
    }

    public static void connect() {
        TwitchAuthToken authToken = TwitchAuthManager.getAuthToken();
        if (authToken != null) {
            twitchChannelManager.createDefaultChannelIfNotExists(authToken.getUsername());
        }
        boolean anonymousLogin = (Boolean)TwitchIntegrationConfig.CLIENT.useAnonymousLogin.get();
        if (authToken != null || anonymousLogin) {
            IRCConfiguration config = TMIClient.defaultConfig();
            config.setEncoding(StandardCharsets.UTF_8);
            if (authToken != null && !anonymousLogin) {
                config.setNick(authToken.getUsername());
                config.setPassword(authToken.getTmiPassword());
            } else {
                config.setNick(TwitchSessionManager.getAnonymousUsername());
            }
            config.setPort((Integer)TwitchIntegrationConfig.CLIENT.port.get());
            for (TwitchChannel channel : twitchChannelManager.getChannels()) {
                if (!channel.isEnabled()) continue;
                joinedChannels.add(channel);
                config.getAutoJoinChannels().add("#" + channel.getName().toLowerCase(Locale.ENGLISH));
            }
            twitchClient = new TMIClient(config, twitchChatHandler);
            twitchClient.connect();
        }
    }

    @Nullable
    public static TMIClient getClient() {
        return twitchClient;
    }

    private static String getAnonymousUsername() {
        return "justinfan" + (int)Math.floor(Math.random() * 80000.0 + 1000.0);
    }

    public static void disconnect() {
        if (twitchClient != null) {
            twitchClient.disconnect();
            twitchClient = null;
        }
    }

    public static boolean isConnected() {
        return twitchClient != null;
    }

    public static TwitchChatHandler getChatHandler() {
        return twitchChatHandler;
    }

    public static TwitchChannelManager getChannelManager() {
        return twitchChannelManager;
    }

    public static List<TwitchChannel> getJoinedChannels() {
        return joinedChannels;
    }

    @SubscribeEvent
    public static void onTwitchChannelEnabled(TwitchChannelEnabledEvent event) {
        TwitchChannel channel = event.getTwitchChannel();
        if (!joinedChannels.contains(channel) && twitchClient != null) {
            twitchClient.join("#" + channel.getName().toLowerCase(Locale.ENGLISH));
            joinedChannels.add(channel);
        }
    }

    @SubscribeEvent
    public static void onTwitchChannelDisabled(TwitchChannelDisabledEvent event) {
        TwitchChannel channel = event.getTwitchChannel();
        if (joinedChannels.remove(channel) && twitchClient != null) {
            twitchClient.part("#" + channel.getName().toLowerCase(Locale.ENGLISH));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            boolean isInGame;
            boolean twitchConnected = TwitchSessionManager.isConnected();
            boolean bl = isInGame = Minecraft.func_71410_x().field_71439_g != null;
            if (twitchConnected && !isInGame) {
                TwitchSessionManager.disconnect();
            } else if (!twitchConnected && isInGame) {
                TwitchSessionManager.connect();
            }
        }
    }

    static {
        joinedChannels = Lists.newArrayList();
    }
}

