/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.auth;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.twitchintegration.TwitchChatIntegration;

public abstract class TokenReceiver
implements Runnable {
    private static final int SO_TIMEOUT = 10000;
    public static final int PORT = 61324;
    private final Thread thread;
    private volatile boolean running;
    private ServerSocket serverSocket;
    private final List<Connection> connections = Lists.newArrayList();

    public TokenReceiver() {
        this.thread = new Thread(this);
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public abstract void onTokenReceived(String var1);

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(61324, 0, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            TwitchChatIntegration.logger.error("Could not listen for the Twitch token: ", (Throwable)e);
            this.stop();
            return;
        }
        while (this.running) {
            try {
                this.connections.add(new Connection(this.serverSocket.accept()));
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        this.closeSockets();
    }

    private void closeSockets() {
        for (Connection connection : this.connections) {
            connection.abort();
        }
        this.connections.clear();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void stop() {
        this.running = false;
        this.closeSockets();
    }

    private static String parseToken(String request) {
        int start = request.indexOf("/token/");
        if (start == -1) {
            return "";
        }
        int end = request.indexOf(" ", start += "/token/".length());
        int end2 = request.indexOf("/", start);
        if (end2 != -1 && end2 < end) {
            end = end2;
        }
        if (end == -1) {
            return "";
        }
        return request.substring(start, end).trim();
    }

    private static String sendFile(String fileName) {
        String content;
        if (fileName == null) {
            return TokenReceiver.makeHeader(false) + "Nothing here...";
        }
        try {
            InputStream input = TokenReceiver.class.getResourceAsStream(fileName);
            if (input != null) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
                StringBuilder buffer = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                content = buffer.toString();
            } else {
                content = "An error occurred (couldn't read file)";
            }
        }
        catch (IOException e) {
            TwitchChatIntegration.logger.error("An error occured in the Twitch token receiver: ", (Throwable)e);
            content = "An error occurred (couldn't read file)";
        }
        return TokenReceiver.makeHeader(true) + content;
    }

    private static String makeHeader(boolean ok) {
        String header = "";
        header = ok ? header + "HTTP/1.0 200 OK\n" : header + "HTTP/1.0 403 Forbidden\n";
        header = header + "Server: TwitchTokenReceiver\n";
        header = header + "Content-Type: text/html; charset=UTF-8\n\n";
        return header;
    }

    private class Connection
    implements Runnable {
        private final Thread thread;
        private final Socket socket;

        public Connection(Socket socket) {
            this.socket = socket;
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            block32: {
                try (BufferedReader input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));){
                    this.socket.setSoTimeout(10000);
                    String request = input.readLine();
                    if (request == null) break block32;
                    try (OutputStream output = this.socket.getOutputStream();){
                        String response;
                        if (request.toLowerCase(Locale.ENGLISH).startsWith("get /token/")) {
                            String token = TokenReceiver.parseToken(request);
                            if (token.isEmpty()) {
                                response = TokenReceiver.sendFile("/token_redirect.html");
                            } else {
                                response = TokenReceiver.sendFile("/token_received.html");
                                TokenReceiver.this.onTokenReceived(token);
                            }
                        } else {
                            response = request.toLowerCase(Locale.ENGLISH).startsWith("get /tokenreceived/") ? TokenReceiver.sendFile("/token_received_no_redirect.html") : TokenReceiver.sendFile(null);
                        }
                        output.write(response.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException ex) {
                        System.err.println("Error responding: " + ex.getLocalizedMessage());
                    }
                }
                catch (IOException e) {
                    TwitchChatIntegration.logger.error("Could not retrieve the Twitch token: ", (Throwable)e);
                }
            }
        }

        public void abort() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

