/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.blay09.mods.twitchintegration.auth.TwitchAuthToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwitchAuthManager {
    private static final Logger logger = LogManager.getLogger();
    private static TwitchAuthToken authToken;

    public static void setAuthToken(String username, String token, boolean storeToken) {
        authToken = new TwitchAuthToken(username, token);
        if (storeToken) {
            TwitchAuthManager.storeToken(authToken);
        }
    }

    public static TwitchAuthToken getAuthToken() {
        return authToken;
    }

    public static void loadStoredToken() {
        File tokenFile = TwitchAuthManager.getTokenFile();
        try (DataInputStream in2 = new DataInputStream(new FileInputStream(tokenFile));){
            TwitchAuthManager.setAuthToken(in2.readUTF(), in2.readUTF(), false);
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            logger.error("An error occurred when trying to load the stored Twitch token ({})", (Object)e.getClass().getSimpleName());
        }
    }

    private static void storeToken(TwitchAuthToken authToken) {
        File tokenFile = TwitchAuthManager.getTokenFile();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(tokenFile));){
            out.writeUTF(authToken.getUsername());
            out.writeUTF(authToken.getToken());
        }
        catch (IOException e) {
            logger.error("An error occurred when trying to store the Twitch token ({})", (Object)e.getClass().getSimpleName());
        }
    }

    private static File getTokenFile() {
        File userHome = new File(System.getProperty("user.home"));
        return new File(userHome, ".tci-auth.dat");
    }
}

