/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.blay09.mods.twitchintegration.TwitchChatIntegration;
import net.blay09.mods.twitchintegration.command.TwitchCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="twitchchatintegration", value={Dist.CLIENT})
public class TwitchClientCommands {
    private static CommandDispatcher<CommandSource> dispatcher;

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        dispatcher = new CommandDispatcher();
        TwitchCommand.register(dispatcher);
        TwitchCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onClientChat(ClientChatEvent event) {
        if (event.getMessage().startsWith("/twitch ")) {
            String message = event.getMessage();
            event.setCanceled(true);
            Minecraft.func_71410_x().func_212871_a_(() -> {
                CommandSource source = Minecraft.func_71410_x().field_71439_g.func_195051_bN();
                TwitchClientCommands.handleCommand(source, message);
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(message);
            });
        }
    }

    private static int handleCommand(CommandSource source, String command) {
        StringReader reader = new StringReader(command);
        if (reader.canRead() && reader.peek() == '/') {
            reader.skip();
        }
        try {
            return dispatcher.execute(reader, (Object)source);
        }
        catch (CommandException e) {
            source.func_197021_a(e.func_197003_a());
            return 0;
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a(TextComponentUtils.func_202465_a((Message)e.getRawMessage()));
            if (e.getInput() != null && e.getCursor() >= 0) {
                int pos = Math.min(e.getInput().length(), e.getCursor());
                IFormattableTextComponent textComponent = new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                if (pos > 10) {
                    textComponent.func_240702_b_("...");
                }
                textComponent.func_240702_b_(e.getInput().substring(Math.max(0, pos - 10), pos));
                if (pos < e.getInput().length()) {
                    IFormattableTextComponent errorComponent = new StringTextComponent(e.getInput().substring(pos)).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    textComponent.func_230529_a_((ITextComponent)errorComponent);
                }
                textComponent.func_230529_a_((ITextComponent)new TranslationTextComponent("command.context.here").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                source.func_197021_a((ITextComponent)textComponent);
            }
        }
        catch (Exception e) {
            StringTextComponent textComponent = new StringTextComponent(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            if (TwitchChatIntegration.logger.isDebugEnabled()) {
                TwitchChatIntegration.logger.error("Command exception: {}", (Object)command, (Object)e);
                StackTraceElement[] stackTrace = e.getStackTrace();
                for (int i = 0; i < Math.min(stackTrace.length, 3); ++i) {
                    textComponent.func_240702_b_("\n\n").func_240702_b_(stackTrace[i].getMethodName()).func_240702_b_("\n ").func_240702_b_(stackTrace[i].getFileName()).func_240702_b_(":").func_240702_b_(String.valueOf(stackTrace[i].getLineNumber()));
                }
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.failed").func_240700_a_(arg_0 -> TwitchClientCommands.lambda$handleCommand$2((IFormattableTextComponent)textComponent, arg_0)));
            if (SharedConstants.field_206244_b) {
                source.func_197021_a((ITextComponent)new StringTextComponent(Util.func_229758_d_((Throwable)e)));
                TwitchChatIntegration.logger.error("'" + command + "' threw an exception", (Throwable)e);
            }
            return 0;
        }
        return 0;
    }

    private static /* synthetic */ Style lambda$handleCommand$2(IFormattableTextComponent textComponent, Style style) {
        return style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)textComponent));
    }
}

