/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.TwitchSessionManager;
import net.blay09.mods.twitchintegration.chat.DeletedMessagesMode;
import net.blay09.mods.twitchintegration.chat.TwitchChannel;
import net.blay09.mods.twitchintegration.gui.screen.TwitchAuthenticationScreen;
import net.blay09.mods.twitchintegration.handler.TwitchChatHandler;
import net.blay09.mods.twitchintegration.util.Messages;
import net.blay09.repack.javatmi.TMIClient;
import net.blay09.repack.javatmi.TwitchMessage;
import net.blay09.repack.javatmi.TwitchUser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.server.command.EnumArgument;

public class TwitchCommand {
    private static final SuggestionProvider<CommandSource> whisperSuggestionProvider = (context, builder) -> {
        for (TwitchUser user : TwitchSessionManager.getChatHandler().getWhisperUsers()) {
            builder.suggest(user.getNick());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSource> channelSuggestionProvider = (context, builder) -> {
        for (TwitchChannel channel : TwitchSessionManager.getChannelManager().getChannels()) {
            builder.suggest(channel.getName());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"twitch").requires(it -> it.func_197022_f() instanceof PlayerEntity && !(it.func_197022_f() instanceof FakePlayer))).then(Commands.func_197057_a((String)"authenticate").executes(TwitchCommand::authenticateTwitch))).then(Commands.func_197057_a((String)"channels").executes(TwitchCommand::listChannels))).then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"channel", (ArgumentType)StringArgumentType.string()).suggests(channelSuggestionProvider).executes(TwitchCommand::joinChannel)))).then(Commands.func_197057_a((String)"leave").then(Commands.func_197056_a((String)"channel", (ArgumentType)StringArgumentType.string()).suggests(channelSuggestionProvider).executes(TwitchCommand::leaveChannel)))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"channel", (ArgumentType)StringArgumentType.string()).suggests(channelSuggestionProvider).executes(TwitchCommand::removeChannel)))).then(Commands.func_197057_a((String)"config").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"channel", (ArgumentType)StringArgumentType.string()).suggests(channelSuggestionProvider).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subscribersOnly").executes(context -> TwitchCommand.printChannelConfig((CommandContext<CommandSource>)context, "subscribersOnly"))).then(Commands.func_197056_a((String)"subscribersOnly", (ArgumentType)BoolArgumentType.bool()).executes(context -> TwitchCommand.changeChannelConfig((CommandContext<CommandSource>)context, "subscribersOnly"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"deletedMessagesMode").executes(context -> TwitchCommand.printChannelConfig((CommandContext<CommandSource>)context, "deletedMessagesMode"))).then(Commands.func_197056_a((String)"mode", (ArgumentType)EnumArgument.enumArgument(DeletedMessagesMode.class)).executes(context -> TwitchCommand.changeChannelConfig((CommandContext<CommandSource>)context, "deletedMessagesMode"))))))).then(Commands.func_197057_a((String)"whisper").then(Commands.func_197056_a((String)"user", (ArgumentType)StringArgumentType.string()).suggests(whisperSuggestionProvider).then(Commands.func_197056_a((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(TwitchCommand::sendWhisper))))).then(Commands.func_197057_a((String)"send").then(Commands.func_197056_a((String)"channel", (ArgumentType)StringArgumentType.string()).suggests(channelSuggestionProvider).then(Commands.func_197056_a((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(TwitchCommand::sendMessage)))));
    }

    private static int sendWhisper(CommandContext<CommandSource> context) {
        String user = StringArgumentType.getString(context, (String)"user");
        String message = StringArgumentType.getString(context, (String)"message");
        TMIClient twitchClient = TwitchSessionManager.getClient();
        if (twitchClient != null) {
            if (TwitchCommand.isReadOnlyChat(twitchClient)) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)Messages.styledLang("error.read_only_chat", TextFormatting.RED, new Object[0]), false);
                return 0;
            }
            twitchClient.getTwitchCommands().whisper(user, message);
            TwitchChatHandler twitchChatHandler = TwitchSessionManager.getChatHandler();
            twitchChatHandler.onWhisperMessage(twitchClient, twitchChatHandler.getOrCreateClientUser(twitchClient, null), twitchChatHandler.getWhisperUser(user), message);
        }
        return 1;
    }

    private static int sendMessage(CommandContext<CommandSource> context) {
        String channel = StringArgumentType.getString(context, (String)"channel");
        String message = StringArgumentType.getString(context, (String)"message");
        TMIClient twitchClient = TwitchSessionManager.getClient();
        if (twitchClient != null) {
            if (TwitchCommand.isReadOnlyChat(twitchClient)) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)Messages.styledLang("error.read_only_chat", TextFormatting.RED, new Object[0]), false);
                return 0;
            }
            twitchClient.send("#" + channel, message);
            TwitchChatHandler twitchChatHandler = TwitchSessionManager.getChatHandler();
            if (message.startsWith("/me ")) {
                message = message.substring(4);
                twitchChatHandler.onChatMessage(twitchClient, channel, twitchChatHandler.getOrCreateClientUser(twitchClient, channel), new TwitchMessage(message, -1, true, 0));
            } else {
                twitchChatHandler.onChatMessage(twitchClient, channel, twitchChatHandler.getOrCreateClientUser(twitchClient, channel), new TwitchMessage(message, -1, false, 0));
            }
        }
        return 1;
    }

    private static int joinChannel(CommandContext<CommandSource> context) {
        String channelName = StringArgumentType.getString(context, (String)"channel");
        TwitchSessionManager.getChannelManager().joinChannel(channelName);
        StringTextComponent channelNameText = Messages.styledString(channelName, TextFormatting.YELLOW);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)Messages.lang("commands.join", channelNameText), false);
        return 1;
    }

    private static int leaveChannel(CommandContext<CommandSource> context) {
        String channelName = StringArgumentType.getString(context, (String)"channel");
        TwitchSessionManager.getChannelManager().leaveChannel(channelName);
        StringTextComponent channelNameText = Messages.styledString(channelName, TextFormatting.YELLOW);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)Messages.lang("commands.leave", channelNameText), false);
        return 1;
    }

    private static int removeChannel(CommandContext<CommandSource> context) {
        String channelName = StringArgumentType.getString(context, (String)"channel");
        TwitchSessionManager.getChannelManager().removeChannelByName(channelName);
        StringTextComponent channelNameText = Messages.styledString(channelName, TextFormatting.YELLOW);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)Messages.lang("commands.remove", channelNameText), false);
        return 1;
    }

    private static int listChannels(CommandContext<CommandSource> context) {
        Collection<TwitchChannel> channels = TwitchSessionManager.getChannelManager().getChannels();
        if (channels.isEmpty()) {
            throw new CommandException((ITextComponent)Messages.lang("commands.channels.noChannels", new Object[0]));
        }
        StringBuilder builder = new StringBuilder();
        for (TwitchChannel channel : channels) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(Messages.format("commands.channels.channelListItem", channel.getName(), channel.isEnabled()));
        }
        StringTextComponent channelListItemsText = Messages.styledString(builder.toString(), TextFormatting.WHITE);
        TranslationTextComponent channelListText = Messages.styledLang("commands.channels.channelList", TextFormatting.YELLOW, channelListItemsText);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)channelListText, false);
        return 1;
    }

    private static int printChannelConfig(CommandContext<CommandSource> context, String option) {
        String channelName = StringArgumentType.getString(context, (String)"channel");
        TwitchChannel channel = TwitchSessionManager.getChannelManager().getChannel(channelName);
        if (channel == null) {
            throw new CommandException((ITextComponent)Messages.lang("commands.config.channelNotFound", channelName));
        }
        Object value = null;
        if (option.equals("subscribersOnly")) {
            value = channel.isSubscribersOnly();
        } else if (option.equals("deletedMessagesMode")) {
            value = channel.getDeletedMessagesMode();
        }
        StringTextComponent channelNameText = Messages.styledString(channelName, TextFormatting.YELLOW);
        StringTextComponent optionText = Messages.styledString(option, TextFormatting.GRAY);
        StringTextComponent valueText = Messages.styledString(String.valueOf(value), TextFormatting.GREEN);
        TranslationTextComponent configText = Messages.lang("commands.config.channelConfigValue", channelNameText, optionText, valueText);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)configText, false);
        return 1;
    }

    private static int changeChannelConfig(CommandContext<CommandSource> context, String option) {
        String channelName = StringArgumentType.getString(context, (String)"channel");
        TwitchChannel channel = TwitchSessionManager.getChannelManager().getChannel(channelName);
        if (channel == null) {
            throw new CommandException((ITextComponent)Messages.lang("commands.config.channelNotFound", channelName));
        }
        Object value = null;
        if (option.equals("subscribersOnly")) {
            boolean subscribersOnly = BoolArgumentType.getBool(context, (String)"subscribersOnly");
            channel.setSubscribersOnly(subscribersOnly);
            value = subscribersOnly;
        } else if (option.equals("deletedMessagesMode")) {
            DeletedMessagesMode mode = (DeletedMessagesMode)((Object)context.getArgument("mode", DeletedMessagesMode.class));
            channel.setDeletedMessagesMode(mode);
            value = mode;
        }
        TwitchSessionManager.getChannelManager().save();
        StringTextComponent channelNameText = Messages.styledString(channelName, TextFormatting.YELLOW);
        StringTextComponent optionText = Messages.styledString(option, TextFormatting.GRAY);
        StringTextComponent valueText = Messages.styledString(String.valueOf(value), TextFormatting.GREEN);
        TranslationTextComponent configText = Messages.lang("commands.config.channelConfigChanged", channelNameText, optionText, valueText);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)configText, false);
        return 1;
    }

    private static int authenticateTwitch(CommandContext<CommandSource> context) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TwitchAuthenticationScreen(null));
        return 1;
    }

    private static boolean isReadOnlyChat(TMIClient twitchClient) {
        return (Boolean)TwitchIntegrationConfig.CLIENT.useAnonymousLogin.get() != false || twitchClient.getIRCConnection().getNick().startsWith("justinfan");
    }
}

