/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.compat.vanilla;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.TwitchSessionManager;
import net.blay09.mods.twitchintegration.api.ChatConsumer;
import net.blay09.mods.twitchintegration.chat.DeletedMessagesMode;
import net.blay09.mods.twitchintegration.chat.TwitchChannel;
import net.blay09.mods.twitchintegration.compat.vanilla.VanillaChatMessage;
import net.blay09.mods.twitchintegration.handler.ChannelUser;
import net.blay09.mods.twitchintegration.util.Messages;
import net.blay09.repack.javatmi.TwitchMessage;
import net.blay09.repack.javatmi.TwitchUser;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;

public class VanillaChatConsumer
implements ChatConsumer {
    private final AtomicInteger idCounter = new AtomicInteger(9000);
    private final Multimap<String, VanillaChatMessage> userMessages = ArrayListMultimap.create();

    @Override
    public void onChatMessage(TwitchChannel channel, TwitchUser user, TwitchMessage message) {
        boolean isMultiChannel;
        Style style = null;
        if (user.getColor() != null) {
            Color color = Color.func_240745_a_((String)user.getColor());
            style = Style.field_240709_b_.func_240718_a_(color);
        }
        TextComponent messageText = (TextComponent)ForgeHooks.newChatWithLinks((String)message.getMessage());
        boolean bl = isMultiChannel = TwitchSessionManager.getJoinedChannels().size() > 1;
        if (isMultiChannel) {
            if (message.isAction()) {
                StringTextComponent channelNameText = Messages.styledString(channel.getName(), TextFormatting.YELLOW);
                StringTextComponent displayNameText = Messages.styledString(user.getDisplayName(), style);
                if (style != null) {
                    messageText.func_240703_c_(style);
                }
                this.printChatMessage((ITextComponent)Messages.lang("chat.multiChannel.action", channelNameText, displayNameText, messageText), user.getNick());
            } else {
                StringTextComponent channelText = Messages.styledString(channel.getName(), TextFormatting.YELLOW);
                StringTextComponent displayNameText = Messages.styledString(user.getDisplayName(), style);
                this.printChatMessage((ITextComponent)Messages.lang("chat.multiChannel.message", channelText, displayNameText, messageText), user.getNick());
            }
        } else if (message.isAction()) {
            this.printChatMessage((ITextComponent)Messages.styledLang("chat.action", style, user.getDisplayName(), messageText), user.getNick());
        } else {
            StringTextComponent displayNameText = Messages.styledString(user.getDisplayName(), style);
            this.printChatMessage((ITextComponent)Messages.lang("chat.message", displayNameText, messageText), user.getNick());
        }
    }

    @Override
    public void onSystemMessage(TwitchChannel channel, ITextComponent message) {
        this.printChatMessage(message, null);
    }

    @Override
    public void onWhisperMessage(TwitchUser user, TwitchMessage message) {
        Style style = null;
        if (user.getColor() != null) {
            Color color = Color.func_240745_a_((String)user.getColor());
            style = Style.field_240709_b_.func_240718_a_(color);
        }
        ITextComponent messageText = ForgeHooks.newChatWithLinks((String)message.getMessage());
        if (message.isAction()) {
            this.printChatMessage((ITextComponent)Messages.styledLang("chat.whisper.action", style, user.getDisplayName(), messageText), user.getNick());
        } else {
            StringTextComponent displayName = Messages.styledString(user.getDisplayName(), style);
            this.printChatMessage((ITextComponent)Messages.lang("chat.whisper.message", displayName, messageText), user.getNick());
        }
    }

    @Override
    public void clearChat(TwitchChannel channel) {
        for (VanillaChatMessage message : this.userMessages.values()) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146242_c(message.getId());
        }
    }

    @Override
    public void purgeUserMessages(TwitchChannel channel, ChannelUser user) {
        if (channel.getDeletedMessagesMode() != DeletedMessagesMode.Show) {
            Collection messages = this.userMessages.get((Object)user.getUsername());
            for (VanillaChatMessage message : messages) {
                if (channel.getDeletedMessagesMode() == DeletedMessagesMode.Hide) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146242_c(message.getId());
                    continue;
                }
                if (channel.getDeletedMessagesMode() == DeletedMessagesMode.Strikethrough) {
                    TextComponent textComponent = (TextComponent)message.getTextComponent();
                    IFormattableTextComponent strikethroughText = textComponent.func_240699_a_(TextFormatting.STRIKETHROUGH);
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)strikethroughText, message.getId());
                    continue;
                }
                if (channel.getDeletedMessagesMode() != DeletedMessagesMode.Replace) continue;
                TranslationTextComponent messageDeletedText = Messages.styledLang("chat.messageDeleted", TextFormatting.GRAY, user.getUsername());
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)messageDeletedText, message.getId());
            }
            messages.clear();
        }
    }

    private void printChatMessage(ITextComponent textComponent, @Nullable String senderNick) {
        int chatLineId = senderNick != null ? this.idCounter.incrementAndGet() : 0;
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a(textComponent, chatLineId);
        if (senderNick != null) {
            this.userMessages.put((Object)senderNick, (Object)new VanillaChatMessage(chatLineId, textComponent));
        }
    }
}

