/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.TwitchSessionManager;
import net.blay09.mods.twitchintegration.auth.TwitchAuthManager;
import net.blay09.mods.twitchintegration.auth.TwitchAuthToken;
import net.blay09.mods.twitchintegration.gui.screen.TwitchOpenTokenScreen;
import net.blay09.mods.twitchintegration.gui.screen.TwitchWaitingForTokenScreen;
import net.blay09.mods.twitchintegration.gui.screen.TwitchWaitingForUsernameScreen;
import net.blay09.mods.twitchintegration.gui.widget.PasswordFieldWidget;
import net.blay09.mods.twitchintegration.util.Messages;
import net.blay09.mods.twitchintegration.util.TwitchAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class TwitchAuthenticationScreen
extends Screen {
    private static final ResourceLocation twitchLogo = new ResourceLocation("twitchchatintegration", "twitch_logo.png");
    private final Screen parentScreen;
    private PasswordFieldWidget tokenTextField;

    public TwitchAuthenticationScreen(@Nullable Screen parentScreen) {
        super((ITextComponent)Messages.lang("gui.authentication.generateToken", new Object[0]));
        this.parentScreen = parentScreen;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        Button getTokenButton = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 25, 200, 20, (ITextComponent)Messages.lang("gui.authentication.generateToken", TextFormatting.GREEN), button -> Minecraft.func_71410_x().func_147108_a((Screen)new TwitchOpenTokenScreen(success -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (success) {
                String url = TwitchAPI.listenForToken(() -> mc.func_147108_a((Screen)new TwitchAuthenticationScreen(this.parentScreen)));
                Util.func_110647_a().func_195640_a(url);
                mc.func_147108_a((Screen)new TwitchWaitingForTokenScreen());
            } else {
                mc.func_147108_a((Screen)this);
            }
        }, TwitchAPI.getAuthenticationURL())));
        this.func_230480_a_((Widget)getTokenButton);
        this.tokenTextField = new PasswordFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 20, 200, 15, (ITextComponent)new StringTextComponent(""));
        TwitchAuthToken tokenPair = TwitchAuthManager.getAuthToken();
        if (tokenPair != null) {
            this.tokenTextField.func_146180_a(tokenPair.getToken());
        }
        this.tokenTextField.func_195607_a((text, index) -> new StringTextComponent(StringUtils.repeat((char)'*', (int)text.length())).func_241878_f());
        this.tokenTextField.func_146184_c((Boolean)TwitchIntegrationConfig.CLIENT.useAnonymousLogin.get() == false);
        this.func_230481_d_((IGuiEventListener)this.tokenTextField);
        this.func_212928_a((IGuiEventListener)this.tokenTextField);
        CheckboxButton anonymousLoginCheckbox = new CheckboxButton(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 45, 165, 20, (ITextComponent)Messages.lang("gui.authentication.anonymousLogin", new Object[0]), (Boolean)TwitchIntegrationConfig.CLIENT.useAnonymousLogin.get()){

            public void func_230930_b_() {
                super.func_230930_b_();
                TwitchIntegrationConfig.CLIENT.useAnonymousLogin.set((Object)this.func_212942_a());
            }
        };
        this.func_230480_a_((Widget)anonymousLoginCheckbox);
        Button connectButton = new Button(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 70, 100, 20, (ITextComponent)Messages.lang("gui.authentication.connect", new Object[0]), button -> {
            TwitchAuthToken authToken = TwitchAuthManager.getAuthToken();
            if (!(((Boolean)TwitchIntegrationConfig.CLIENT.useAnonymousLogin.get()).booleanValue() || authToken != null && authToken.getToken().equals(this.tokenTextField.func_146179_b()) && authToken.getUsername() != null)) {
                Minecraft.func_71410_x().func_147108_a((Screen)new TwitchWaitingForUsernameScreen());
                TwitchAPI.requestUsername(this.tokenTextField.func_146179_b(), TwitchSessionManager::connect);
            } else {
                if (TwitchSessionManager.isConnected()) {
                    TwitchSessionManager.disconnect();
                } else {
                    TwitchSessionManager.connect();
                }
                Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            }
        });
        if (TwitchSessionManager.isConnected()) {
            connectButton.func_238482_a_((ITextComponent)Messages.lang("gui.authentication.disconnect", new Object[0]));
        }
        this.func_230480_a_((Widget)connectButton);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Objects.requireNonNull(this.getMinecraft().field_71439_g).func_71053_j();
        }
        return this.tokenTextField.func_231046_a_(keyCode, scanCode, modifiers) || this.tokenTextField.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int windowHalfWidth = 150;
        int windowHalfHeight = 100;
        TwitchAuthenticationScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - 150), (int)(this.field_230709_l_ / 2 - 100), (int)(this.field_230708_k_ / 2 + 150), (int)(this.field_230709_l_ / 2 + 100), (int)-587202560);
        this.func_238465_a_(matrixStack, this.field_230708_k_ / 2 - 150 - 1, this.field_230708_k_ / 2 + 150, this.field_230709_l_ / 2 - 100 - 1, -1);
        this.func_238465_a_(matrixStack, this.field_230708_k_ / 2 - 150 - 1, this.field_230708_k_ / 2 + 150, this.field_230709_l_ / 2 + 100, -1);
        this.func_238473_b_(matrixStack, this.field_230708_k_ / 2 - 150 - 1, this.field_230709_l_ / 2 - 100 - 1, this.field_230709_l_ / 2 + 100, -1);
        this.func_238473_b_(matrixStack, this.field_230708_k_ / 2 + 150, this.field_230709_l_ / 2 - 100 - 1, this.field_230709_l_ / 2 + 100, -1);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(twitchLogo);
        TwitchAuthenticationScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - 64), (int)(this.field_230709_l_ / 2 - 80), (float)0.0f, (float)0.0f, (int)128, (int)43, (int)128, (int)43);
        TwitchAuthenticationScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)Messages.format("gui.authentication.chatToken", new Object[0]), (int)(this.field_230708_k_ / 2 - 100), (int)(this.field_230709_l_ / 2 + 5), (int)0xFFFFFF);
        this.tokenTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

