/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.handler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.TwitchChatIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.TwitchSessionManager;
import net.blay09.mods.twitchintegration.api.ChatConsumer;
import net.blay09.mods.twitchintegration.chat.TwitchChannel;
import net.blay09.mods.twitchintegration.compat.vanilla.VanillaChatConsumer;
import net.blay09.mods.twitchintegration.handler.ChannelUser;
import net.blay09.mods.twitchintegration.util.Messages;
import net.blay09.repack.javairc.IRCUser;
import net.blay09.repack.javatmi.GiftPaidUpgradeInfo;
import net.blay09.repack.javatmi.GiftSubscriptionInfo;
import net.blay09.repack.javatmi.SubscriptionInfo;
import net.blay09.repack.javatmi.TMIAdapter;
import net.blay09.repack.javatmi.TMIClient;
import net.blay09.repack.javatmi.TwitchMessage;
import net.blay09.repack.javatmi.TwitchUser;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TwitchChatHandler
extends TMIAdapter {
    private final ChatConsumer chatConsumer = new VanillaChatConsumer();
    private final Multimap<ChannelUser, TwitchMessage> messages = ArrayListMultimap.create();
    private final Map<String, TwitchUser> whisperUsers = Maps.newHashMap();
    private final Table<String, String, TwitchUser> usersByChannel = HashBasedTable.create();

    private void storeUserState(@Nullable String channel, TwitchUser user) {
        if (channel != null) {
            this.usersByChannel.put((Object)channel, (Object)user.getNick(), (Object)user);
        } else {
            this.whisperUsers.put(user.getNick(), user);
        }
    }

    @Override
    public void onUserState(TMIClient client, String channel, TwitchUser user) {
        this.storeUserState(channel, user);
    }

    @Override
    public void onChatMessage(TMIClient client, String channel, TwitchUser user, TwitchMessage message) {
        this.onTwitchChat(client, channel, user, message);
    }

    private void onTwitchChat(TMIClient client, String channel, TwitchUser user, TwitchMessage twitchMessage) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            if (twitchChannel != null && twitchChannel.isSubscribersOnly() && !user.isSubscriber() && !user.isMod()) {
                return;
            }
            if (this.isBlacklisted(user)) {
                return;
            }
            if (twitchChannel != null && !twitchChannel.hasChannelId() && twitchMessage.getChannelId() != -1) {
                twitchChannel.setChannelId(twitchMessage.getChannelId());
            }
            boolean isSelf = user.getNick().equals(client.getIRCConnection().getNick());
            String message = twitchMessage.getMessage();
            this.chatConsumer.onChatMessage(twitchChannel, user, twitchMessage);
            this.messages.put((Object)new ChannelUser(channel, user.getNick().toLowerCase(Locale.ENGLISH)), (Object)twitchMessage);
            this.storeUserState(channel, user);
        });
    }

    private boolean isBlacklisted(TwitchUser user) {
        return ((List)TwitchIntegrationConfig.CLIENT.userBlacklist.get()).stream().anyMatch(it -> user.getNick().equalsIgnoreCase((String)it));
    }

    @Override
    public void onSubscribe(TMIClient client, String channel, TwitchUser user, SubscriptionInfo subscriptionInfo) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            TranslationTextComponent subscribeText = Messages.styledLang(subscriptionInfo.isPrime() ? "chat.subscribePrime" : "chat.subscribe", TextFormatting.YELLOW, user.getDisplayName());
            this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)subscribeText);
        });
    }

    @Override
    public void onResubscribe(TMIClient client, String channel, TwitchUser user, SubscriptionInfo subscriptionInfo) {
        super.onResubscribe(client, channel, user, subscriptionInfo);
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            TranslationTextComponent resubscribeText = Messages.styledLang("chat.resubscribe", TextFormatting.YELLOW, user.getDisplayName(), subscriptionInfo.getCumulativeMonths());
            this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)resubscribeText);
        });
        if (subscriptionInfo.getMessage() != null) {
            this.onTwitchChat(client, channel, user, new TwitchMessage(subscriptionInfo.getMessage(), -1, false, 0));
        }
    }

    @Override
    public void onGiftSubscription(TMIClient client, String channel, TwitchUser user, GiftSubscriptionInfo giftSubscriptionInfo) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            if (giftSubscriptionInfo.isSenderAnonymous()) {
                TranslationTextComponent giftSubscribeText = Messages.styledLang("chat.giftSubscribeAnonymous", TextFormatting.YELLOW, giftSubscriptionInfo.getRecipientDisplayName());
                this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)giftSubscribeText);
            } else {
                TranslationTextComponent giftSubscribeText = Messages.styledLang("chat.giftSubscribe", TextFormatting.YELLOW, user.getDisplayName(), giftSubscriptionInfo.getRecipientDisplayName());
                this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)giftSubscribeText);
            }
        });
    }

    @Override
    public void onGiftPaidUpgrade(TMIClient client, String channel, TwitchUser user, GiftPaidUpgradeInfo giftPaidUpgradeInfo) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            if (giftPaidUpgradeInfo.isSenderAnonymous()) {
                TranslationTextComponent giftSubscribeText = Messages.styledLang("chat.giftPaidUpgradeAnonymous", TextFormatting.YELLOW, user.getDisplayName());
                this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)giftSubscribeText);
            } else {
                TranslationTextComponent giftSubscribeText = Messages.styledLang("chat.giftPaidUpgrade", TextFormatting.YELLOW, user.getDisplayName(), giftPaidUpgradeInfo.getSenderName());
                this.chatConsumer.onSystemMessage(twitchChannel, (ITextComponent)giftSubscribeText);
            }
        });
    }

    @Override
    public void onWhisperMessage(TMIClient client, TwitchUser user, String message) {
        this.onWhisperMessage(client, user, this.getOrCreateClientUser(client, null), message);
    }

    public void onWhisperMessage(TMIClient client, TwitchUser user, TwitchUser receiver, String message) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (((Boolean)TwitchIntegrationConfig.CLIENT.showWhispers.get()).booleanValue()) {
                boolean isSelf = user.getNick().equals(client.getIRCConnection().getNick());
                this.storeUserState(null, user);
                this.chatConsumer.onWhisperMessage(user, new TwitchMessage(message, -1, false, 0));
            }
        });
    }

    @Override
    public void onTimeout(TMIClient client, String channel, String username) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            if (twitchChannel != null) {
                this.chatConsumer.purgeUserMessages(twitchChannel, new ChannelUser(channel, username));
            }
        });
    }

    @Override
    public void onClearChat(TMIClient client, String channel) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            TwitchChannel twitchChannel = TwitchSessionManager.getChannelManager().getChannel(channel);
            this.chatConsumer.clearChat(twitchChannel);
        });
    }

    @Override
    public void onUnhandledException(TMIClient client, Exception e) {
        TwitchChatIntegration.logger.error("Unhandled exception: ", (Throwable)e);
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Twitch Integration encountered an unhandled exception. The connection has been terminated. Please review your log files and let the mod developer know."), false);
            }
        });
        TwitchSessionManager.disconnect();
    }

    public TwitchUser getOrCreateClientUser(TMIClient client, String channel) {
        String username = client.getIRCConnection().getNick();
        TwitchUser user = (TwitchUser)this.usersByChannel.get((Object)username, (Object)channel);
        if (user == null) {
            user = new TwitchUser(new IRCUser(username, null, null));
            this.storeUserState(channel, user);
        }
        return user;
    }

    public TwitchUser getWhisperUser(String username) {
        return this.whisperUsers.computeIfAbsent(username.toLowerCase(Locale.ENGLISH), k -> new TwitchUser(new IRCUser(username, null, null)));
    }

    public Collection<TwitchUser> getWhisperUsers() {
        return this.whisperUsers.values();
    }
}

