/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachedAPI {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new Gson();
    private static final HttpClient httpClient = HttpClients.createDefault();
    private static final long DEFAULT_CACHE_TIME = 86400000L;

    @Nullable
    public static JsonObject loadCachedAPI(String url, String fileName) {
        return CachedAPI.loadCachedAPI(new HttpGet(url), fileName, 86400000L);
    }

    @Nullable
    public static JsonObject loadCachedAPI(HttpGet request, String fileName) {
        return CachedAPI.loadCachedAPI(request, fileName, 86400000L);
    }

    @Nullable
    private static JsonObject loadCachedAPI(HttpGet request, String fileName, long maxCacheTime) {
        return CachedAPI.loadCachedAPI(request, new File(CachedAPI.getCacheDirectory(), fileName), maxCacheTime);
    }

    @Nullable
    private static JsonObject loadCachedAPI(HttpGet request, File cacheFile, long maxCacheTime) {
        JsonObject result = CachedAPI.loadLocal(cacheFile, false, maxCacheTime);
        if (result == null) {
            result = CachedAPI.loadRemote(request);
            if (result == null) {
                result = CachedAPI.loadLocal(cacheFile, true, maxCacheTime);
            } else {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(cacheFile));){
                    gson.toJson((JsonElement)result, (Appendable)writer);
                }
                catch (IOException e) {
                    logger.error("An error occurred trying to cache an API result: ", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject loadLocal(File file, boolean force, long maxCacheTime) {
        if (!file.exists()) return null;
        if (!force) {
            if (System.currentTimeMillis() - file.lastModified() >= maxCacheTime) return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            logger.error("An error occurred trying to load a cached API result: ", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static JsonObject loadRemote(HttpGet request) {
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            String jsonString = EntityUtils.toString((HttpEntity)response.getEntity());
            return (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            Header authHeader = request.getFirstHeader("Authorization");
            if (authHeader != null) {
                for (String authHeaderPart : authHeader.getValue().split(" ")) {
                    exceptionMessage = exceptionMessage.replace(authHeaderPart, "<secret>");
                }
            }
            logger.error("An error occurred trying to load from an API: {}", (Object)exceptionMessage);
            return null;
        }
    }

    private static File getCacheDirectory() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "ChatTweaks/cache/");
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Could not create cache directory for Chat Tweaks.");
        }
        return file;
    }
}

