/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.repack.javairc.snapshot;

import java.util.Map;
import net.blay09.repack.javairc.IRCChannelUserMode;
import net.blay09.repack.javairc.IRCConnection;
import net.blay09.repack.javairc.IRCListener;
import net.blay09.repack.javairc.IRCMessage;
import net.blay09.repack.javairc.IRCUser;
import net.blay09.repack.javairc.snapshot.ChannelSnapshot;
import net.blay09.repack.javairc.snapshot.UserSnapshot;

public class SnapshotWrapper
implements IRCListener {
    private final IRCListener parent;
    private final Map<String, ChannelSnapshot> channels;
    private final Map<String, UserSnapshot> users;

    public SnapshotWrapper(IRCListener parent, Map<String, ChannelSnapshot> channels, Map<String, UserSnapshot> users) {
        this.parent = parent;
        this.channels = channels;
        this.users = users;
    }

    private UserSnapshot getUserSnapshot(String nick) {
        UserSnapshot user = this.users.get(nick.toLowerCase());
        if (user == null) {
            user = new UserSnapshot(nick);
            this.users.put(nick.toLowerCase(), user);
        }
        return user;
    }

    private ChannelSnapshot getChannelSnapshot(String name) {
        ChannelSnapshot channel = this.channels.get(name.toLowerCase());
        if (channel == null) {
            channel = new ChannelSnapshot(name);
            this.channels.put(name.toLowerCase(), channel);
        }
        return channel;
    }

    @Override
    public boolean onRawMessage(IRCConnection connection, IRCMessage message) {
        int numeric = message.getNumericCommand();
        switch (numeric) {
            case 307: 
            case 320: {
                this.getUserSnapshot(message.arg(1)).setLoginName(message.arg(1));
                break;
            }
            case 330: {
                this.getUserSnapshot(message.arg(1)).setLoginName(message.arg(2));
                break;
            }
            case 353: {
                String[] names;
                ChannelSnapshot channel = this.getChannelSnapshot(message.arg(0));
                for (String name : names = message.arg(2).split(" ")) {
                    char firstChar = name.charAt(0);
                    int idx = connection.getChannelUserModePrefixes().indexOf(firstChar);
                    IRCChannelUserMode mode = null;
                    if (idx != -1) {
                        mode = IRCChannelUserMode.fromChar(connection.getChannelUserModes().charAt(idx));
                        name = name.substring(1);
                    }
                    UserSnapshot user = this.getUserSnapshot(name);
                    if (mode != null) {
                        user.getChannelModes().put(channel.getName(), mode);
                    }
                    user.getChannels().add(channel);
                    channel.getUsers().add(user);
                }
                break;
            }
        }
        return this.parent.onRawMessage(connection, message);
    }

    @Override
    public void onUnhandledException(IRCConnection connection, Exception e) {
        this.parent.onUnhandledException(connection, e);
    }

    @Override
    public void onConnectionFailed(IRCConnection connection, Exception e) {
        this.parent.onConnectionFailed(connection, e);
    }

    @Override
    public void onConnected(IRCConnection connection) {
        this.parent.onConnected(connection);
    }

    @Override
    public void onDisconnected(IRCConnection connection) {
        this.parent.onDisconnected(connection);
    }

    @Override
    public void onUserJoin(IRCConnection connection, IRCMessage message, IRCUser user, String channel) {
        ChannelSnapshot channelSnapshot = this.getChannelSnapshot(channel);
        UserSnapshot userSnapshot = this.getUserSnapshot(user.getNick());
        channelSnapshot.getUsers().add(userSnapshot);
        userSnapshot.getChannels().add(channelSnapshot);
        this.parent.onUserJoin(connection, message, user, channel);
    }

    @Override
    public void onUserPart(IRCConnection connection, IRCMessage message, IRCUser user, String channel, String quitMessage) {
        ChannelSnapshot channelSnapshot = this.getChannelSnapshot(channel);
        UserSnapshot userSnapshot = this.getUserSnapshot(user.getNick());
        channelSnapshot.getUsers().remove(userSnapshot);
        userSnapshot.getChannels().remove(channelSnapshot);
        this.parent.onUserPart(connection, message, user, channel, quitMessage);
    }

    @Override
    public void onUserQuit(IRCConnection connection, IRCMessage message, IRCUser user, String quitMessage) {
        UserSnapshot userSnapshot = this.getUserSnapshot(user.getNick());
        for (ChannelSnapshot channelSnapshot : userSnapshot.getChannels()) {
            channelSnapshot.getUsers().remove(userSnapshot);
        }
        userSnapshot.getChannels().clear();
        this.parent.onUserQuit(connection, message, user, quitMessage);
    }

    @Override
    public void onUserNickChange(IRCConnection connection, IRCMessage message, IRCUser user, String nick) {
        UserSnapshot userSnapshot = this.getUserSnapshot(user.getNick());
        this.users.remove(user.getNick());
        userSnapshot.setNick(nick);
        this.users.put(nick, userSnapshot);
        this.parent.onUserNickChange(connection, message, user, nick);
    }

    @Override
    public void onChannelTopic(IRCConnection connection, IRCMessage message, String channel, String topic) {
        this.getChannelSnapshot(channel).setTopic(topic);
        this.parent.onChannelTopic(connection, message, channel, topic);
    }

    @Override
    public void onChannelTopicChange(IRCConnection connection, IRCMessage message, IRCUser user, String channel, String topic) {
        this.getChannelSnapshot(channel).setTopic(topic);
        this.parent.onChannelTopicChange(connection, message, user, channel, topic);
    }

    @Override
    public void onChannelNotice(IRCConnection connection, IRCMessage message, IRCUser user, String channel, String text) {
        this.parent.onChannelNotice(connection, message, user, channel, text);
    }

    @Override
    public void onUserNotice(IRCConnection connection, IRCMessage message, IRCUser user, String text) {
        this.parent.onUserNotice(connection, message, user, text);
    }

    @Override
    public void onChannelChat(IRCConnection connection, IRCMessage message, IRCUser user, String channel, String text) {
        this.parent.onChannelChat(connection, message, user, channel, text);
    }

    @Override
    public void onUserChat(IRCConnection connection, IRCMessage message, IRCUser user, String text) {
        this.parent.onUserChat(connection, message, user, text);
    }

    @Override
    public void onChannelMode(IRCConnection connection, IRCMessage message, IRCUser user, String channel, String flags, String[] args) {
        this.parent.onChannelMode(connection, message, user, channel, flags, args);
    }

    @Override
    public void onUserMode(IRCConnection connection, IRCMessage message, IRCUser user, String flags, String[] args) {
        this.parent.onUserMode(connection, message, user, flags, args);
    }
}

