/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineConfig;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.hooks.PlayerHooks;
import me.shedaniel.architectury.hooks.TagHooks;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final ITag.INamedTag<Item> denyTag;
    public static final ITag.INamedTag<Item> strictDenyTag;
    public static final ITag.INamedTag<Item> allowTag;
    private static Predicate<PlayerEntity> permissionOverride;

    public static void setPermissionOverride(Predicate<PlayerEntity> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltimineConfig.init();
        Shape.register(new ShapelessShape());
        Shape.register(new SmallTunnelShape());
        Shape.register(new SmallSquareShape());
        Shape.register(new MiningTunnelShape());
        Shape.register(new EscapeTunnelShape());
        Shape.postinit();
        LifecycleEvent.SERVER_BEFORE_START.register(__ -> {
            this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        });
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
    }

    public FTBUltiminePlayerData get(PlayerEntity player) {
        return this.cachedDataMap.computeIfAbsent(player.func_110124_au(), FTBUltiminePlayerData::new);
    }

    public void setKeyPressed(ServerPlayerEntity player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        data.pressed = pressed;
        data.clearCache();
        if (!data.pressed) {
            FTBUltimineNet.MAIN.sendToPlayer(player, (Object)new SendShapePacket(data.shape, Collections.emptyList()));
        }
    }

    public void modeChanged(ServerPlayerEntity player, boolean next) {
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        data.shape = next ? data.shape.next : data.shape.prev;
        data.clearCache();
        FTBUltimineNet.MAIN.sendToPlayer(player, (Object)new SendShapePacket(data.shape, Collections.emptyList()));
    }

    private int getMaxBlocks(PlayerEntity player) {
        return FTBUltimineConfig.get().maxBlocks;
    }

    public boolean canUltimine(PlayerEntity player) {
        if (PlayerHooks.isFake((PlayerEntity)player) || player.func_110124_au() == null) {
            return false;
        }
        if (player.func_71024_bL().func_75116_a() <= 0 && !player.func_184812_l_()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        Item mainHand = player.func_184614_ca().func_77973_b();
        Item offHand = player.func_184592_cb().func_77973_b();
        if (mainHand.func_206844_a(strictDenyTag) || offHand.func_206844_a(strictDenyTag)) {
            return false;
        }
        if (mainHand.func_206844_a(denyTag)) {
            return false;
        }
        List allowedTools = allowTag.func_230236_b_();
        return allowedTools.isEmpty() || allowedTools.contains(mainHand);
    }

    public ActionResultType blockBroken(World world, BlockPos pos, BlockState state, ServerPlayerEntity player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((PlayerEntity)player)) {
            return ActionResultType.PASS;
        }
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        if (!data.pressed) {
            return ActionResultType.PASS;
        }
        RayTraceResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResultType.PASS;
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((BlockRayTraceResult)result).func_216354_b(), false, this.getMaxBlocks((PlayerEntity)player));
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return ActionResultType.PASS;
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.func_184614_ca().func_190926_b();
        for (BlockPos p : data.cachedBlocks) {
            if (!player.field_71134_c.func_180237_b(p)) continue;
            if (!player.func_184812_l_()) {
                player.func_71020_j((float)(FTBUltimineConfig.get().exhaustionPerBlock * 0.005));
                if (player.func_71024_bL().func_75116_a() <= 0) break;
            }
            if (!hadItem || !player.func_184614_ca().func_190926_b()) continue;
            break;
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.field_70170_p, pos);
        if (this.tempBlockDroppedXp > 0) {
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        FTBUltimineNet.MAIN.sendToPlayer(player, (Object)new SendShapePacket(data.shape, Collections.emptyList()));
        return ActionResultType.FAIL;
    }

    public ActionResultType blockRightClick(PlayerEntity player, Hand hand, BlockPos clickPos, Direction face) {
        if (!(player instanceof ServerPlayerEntity) || PlayerHooks.isFake((PlayerEntity)player) || player.func_110124_au() == null) {
            return ActionResultType.PASS;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        if (player.func_71024_bL().func_75116_a() <= 0 && !player.func_184812_l_()) {
            return ActionResultType.PASS;
        }
        RayTraceResult result = FTBUltiminePlayerData.rayTrace(serverPlayer);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResultType.PASS;
        }
        FTBUltiminePlayerData data = this.get(player);
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, ((BlockRayTraceResult)result).func_216354_b(), false, this.getMaxBlocks(player));
        if (shapeContext == null || !data.pressed || data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return ActionResultType.PASS;
        }
        if (player.func_184586_b(hand).func_77973_b() instanceof HoeItem) {
            ResourceLocation dirtTag = new ResourceLocation(MOD_ID, "farmland_tillable");
            if (!player.field_70170_p.func_201670_d()) {
                boolean playSound = false;
                BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
                for (int i = 0; i < Math.min(data.cachedBlocks.size(), FTBUltimineConfig.get().maxBlocks); ++i) {
                    BlockPos p = data.cachedBlocks.get(i);
                    BlockState state = player.field_70170_p.func_180495_p(p);
                    if (!BlockTags.func_199896_a().func_241834_b(dirtTag).func_230235_a_((Object)state.func_177230_c())) continue;
                    player.field_70170_p.func_180501_a(p, Blocks.field_150458_ak.func_176223_P(), 11);
                    playSound = true;
                    if (player.func_184812_l_()) continue;
                    player.func_184614_ca().func_222118_a(1, (LivingEntity)serverPlayer, (Consumer)brokenItemHandler);
                    player.func_71020_j((float)(FTBUltimineConfig.get().exhaustionPerBlock * 0.005));
                    if (brokenItemHandler.isBroken || player.func_71024_bL().func_75116_a() <= 0) break;
                }
                if (playSound) {
                    player.field_70170_p.func_184133_a(player, clickPos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            player.func_184609_a(hand);
            return ActionResultType.FAIL;
        }
        if (shapeContext.matcher == BlockMatcher.BUSH) {
            ItemCollection itemCollection = new ItemCollection();
            for (BlockPos pos : data.cachedBlocks) {
                CropsBlock c;
                BlockState state = player.field_70170_p.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof CropsBlock) || !(c = (CropsBlock)state.func_177230_c()).func_185525_y(state)) continue;
                if (player.field_70170_p.func_201670_d()) {
                    player.func_184609_a(hand);
                    continue;
                }
                List drops = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)player.field_70170_p), (BlockPos)pos, (TileEntity)(state.func_177230_c().func_235695_q_() ? player.field_70170_p.func_175625_s(pos) : null), (Entity)player, (ItemStack)ItemStack.field_190927_a);
                for (ItemStack stack : drops) {
                    if (Block.func_149634_a((Item)stack.func_77973_b()) == c) {
                        stack.func_190918_g(1);
                    }
                    itemCollection.add(stack);
                }
                player.field_70170_p.func_180501_a(pos, c.func_185528_e(0), 3);
            }
            itemCollection.drop(player.field_70170_p, face == null ? clickPos : clickPos.func_177972_a(face));
            player.func_184609_a(hand);
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public void playerTick(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            FTBUltiminePlayerData data = this.get(player);
            data.checkBlocks((ServerPlayerEntity)player, true, this.getMaxBlocks(player));
        }
    }

    public ActionResultType entityJoinedWorld(Entity entity, World level) {
        if (this.isBreakingBlock && entity instanceof ItemEntity) {
            this.tempBlockDropsList.add(((ItemEntity)entity).func_92059_d());
            return ActionResultType.FAIL;
        }
        if (this.isBreakingBlock && entity instanceof ExperienceOrbEntity) {
            this.tempBlockDroppedXp += ((ExperienceOrbEntity)entity).func_70526_d();
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        LOGGER = LogManager.getLogger();
        denyTag = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools"));
        strictDenyTag = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools/strict"));
        allowTag = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation(MOD_ID, "included_tools"));
        permissionOverride = player -> true;
    }
}

